/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.controller;

import eu.dnetlib.apps.oai.controller.ApiController;
import eu.dnetlib.apps.oai.model.CollectionInfo;
import eu.dnetlib.apps.oai.model.ExecutionStatus;
import eu.dnetlib.apps.oai.service.CollectorService;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ApiController {
    private static final Log log = LogFactory.getLog(ApiController.class);
    @Autowired
    private CollectorService service;

    @GetMapping(value={"/collect"})
    public CollectionInfo startCollection(@RequestParam String oaiBaseUrl, @RequestParam(required=false, defaultValue="oai_dc") String oaiFormat, @RequestParam(required=false) String oaiSet, @RequestParam(required=false) LocalDateTime oaiFrom, @RequestParam(required=false) LocalDateTime oaiUntil, @RequestParam(required=false, defaultValue="${oai.conf.maxRecords}") Long max, @RequestParam(required=false) String notificationEmail) {
        return this.service.startCollection(oaiBaseUrl, oaiFormat, oaiSet, oaiFrom, oaiUntil, max, notificationEmail);
    }

    @GetMapping(value={"/history/{id}"})
    public CollectionInfo getCollectionInfo(@PathVariable String id) {
        return this.service.getCollectionInfo(id);
    }

    @GetMapping(value={"/history"})
    public Map<String, ExecutionStatus> history(@RequestParam(required=false, defaultValue="false") boolean all) {
        return this.service.history(all);
    }

    @DeleteMapping(value={"/history"})
    public Map<String, ExecutionStatus> cleanHistory(@RequestParam(required=false, defaultValue="false") boolean all) throws Exception {
        if (all) {
            this.service.forceExpired();
        }
        this.service.cronCleanJobs();
        return this.history(true);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error processing http method", (Throwable)e);
        return new ErrorMessage(this, e);
    }
}

