/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.service;

import eu.dnetlib.apps.oai.model.CollectionCall;
import eu.dnetlib.apps.oai.model.CollectionInfo;
import eu.dnetlib.apps.oai.model.ExecutionStatus;
import eu.dnetlib.apps.oai.repository.CollectionInfoRepository;
import eu.dnetlib.apps.oai.storage.StorageClient;
import eu.dnetlib.apps.oai.storage.StorageClientFactory;
import eu.dnetlib.apps.oai.utils.EmailSender;
import eu.dnetlib.apps.oai.utils.HttpFetcher;
import eu.dnetlib.apps.oai.utils.SimpleUtils;
import jakarta.transaction.Transactional;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CollectorService {
    private static final Log log = LogFactory.getLog(CollectorService.class);
    private final ExecutorService jobExecutor = Executors.newFixedThreadPool(100);
    private final Map<String, CollectionInfo> infoMap = new LinkedHashMap();
    @Autowired
    private StorageClientFactory storageClientFactory;
    @Value(value="${oai.conf.execution.duration.hours}")
    private long executionDuration;
    @Autowired
    private CollectionInfoRepository collectionInfoRepository;
    @Value(value="${oai.conf.app.public_url}")
    private String publicBasePath;
    @Autowired
    private EmailSender emailSender;

    public CollectionInfo startCollection(String baseUrl, String format, String setSpec, LocalDateTime from, LocalDateTime until, Long max, String notificationEmail) {
        String jobId = SimpleUtils.generateNewJobId();
        StorageClient sc = this.storageClientFactory.newClient(jobId);
        CollectionInfo info = new CollectionInfo();
        info.setId(jobId);
        info.setOaiBaseUrl(baseUrl);
        info.setOaiFormat(format);
        info.setOaiSet(setSpec);
        info.setOaiFrom(from);
        info.setOaiUntil(until);
        info.setStorageUrl(sc.getStorageUrl());
        info.setPublicUrl(null);
        info.setStart(LocalDateTime.now());
        info.setExecutionStatus(ExecutionStatus.READY);
        if (StringUtils.isNotBlank((CharSequence)notificationEmail)) {
            info.setNotificationEmail(notificationEmail);
        }
        if (max != null && max > 0L) {
            info.setMax(max.longValue());
        } else {
            info.setMax(Long.MAX_VALUE);
        }
        this.infoMap.put(jobId, info);
        this.jobExecutor.execute(() -> {
            try {
                info.setExecutionStatus(ExecutionStatus.RUNNING);
                this.oaiCollect(sc, info);
                info.setExecutionStatus(ExecutionStatus.COMPLETED);
                if (info.getStorageUrl().endsWith(".zip")) {
                    info.setPublicUrl(this.publicBasePath + "/download/" + jobId);
                }
            }
            catch (Throwable e) {
                info.setExecutionStatus(ExecutionStatus.FAILED);
                info.setMessage(e.getMessage() + ": " + ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                sc.complete();
                LocalDateTime now = LocalDateTime.now();
                info.setEnd(now);
                info.setExpirationDate(now.plusHours(this.executionDuration));
                this.collectionInfoRepository.save((Object)info);
                this.emailSender.sendNotification(info);
            }
        });
        return info;
    }

    public void oaiCollect(StorageClient sc, CollectionInfo info) throws Exception {
        String baseUrl = info.getOaiBaseUrl();
        String url = SimpleUtils.oaiFirstUrl((String)baseUrl, (String)info.getOaiFormat(), (String)info.getOaiSet(), (LocalDateTime)info.getOaiFrom(), (LocalDateTime)info.getOaiUntil());
        long count = 1L;
        while (StringUtils.isNotBlank((CharSequence)url)) {
            CollectionCall call = new CollectionCall();
            call.setUrl(url);
            info.getCalls().add(call);
            String xml = HttpFetcher.download((CollectionCall)call);
            Document doc = DocumentHelper.parseText((String)xml);
            Node errorNode = doc.selectSingleNode("/*[local-name()='OAI-PMH']/*[local-name()='error']");
            if (errorNode != null) {
                String errorCode = errorNode.valueOf("@code");
                String errorMessage = errorNode.getText();
                call.setNumberOfRecords(0L);
                throw new IllegalArgumentException(errorCode + " - " + (String)errorMessage);
            }
            List records = doc.selectNodes("//*[local-name()='ListRecords']/*[local-name()='record']");
            call.setNumberOfRecords((long)records.size());
            sc.prepareCurrentPage(count++);
            for (Node n : records) {
                if (info.getTotal() >= info.getMax()) continue;
                String id = n.valueOf(".//*[local-name()='header']/*[local-name()='identifier']");
                sc.saveFile(SimpleUtils.oaiIdToFilename((String)id), n.asXML());
                info.setTotal(info.getTotal() + 1L);
            }
            if (info.getTotal() < info.getMax()) {
                String rtoken = doc.valueOf("//*[local-name()='resumptionToken']").trim();
                url = SimpleUtils.oaiNextUrl((String)baseUrl, (String)rtoken);
                continue;
            }
            url = null;
        }
    }

    public CollectionInfo getCollectionInfo(String jobId) {
        CollectionInfo info = (CollectionInfo)this.infoMap.get(jobId);
        if (info != null) {
            return info;
        }
        return (CollectionInfo)this.collectionInfoRepository.findById((Object)jobId).orElseThrow(() -> new RuntimeException("Invalid id: " + jobId));
    }

    @Scheduled(fixedRate=30L, timeUnit=TimeUnit.MINUTES)
    public void cronCleanJobs() throws Exception {
        List toClean = this.collectionInfoRepository.findAll().stream().filter(info -> {
            ExecutionStatus status = info.getExecutionStatus();
            return status == ExecutionStatus.COMPLETED || status == ExecutionStatus.FAILED;
        }).filter(info -> {
            LocalDateTime expDate = info.getExpirationDate();
            return expDate != null && expDate.isBefore(LocalDateTime.now());
        }).collect(Collectors.toList());
        for (CollectionInfo info2 : toClean) {
            log.info((Object)("[CLEAN] Cleaning expired job: " + info2.getId()));
            this.infoMap.remove(info2.getId());
            info2.setExecutionStatus(ExecutionStatus.EXPIRED);
            this.collectionInfoRepository.save((Object)info2);
            CollectorService.cleanCollectedData((String)info2.getStorageUrl());
        }
    }

    public Map<String, ExecutionStatus> history(boolean includeExpired) {
        LinkedHashMap<String, ExecutionStatus> res = new LinkedHashMap<String, ExecutionStatus>();
        res.putAll(this.history((Collection)this.collectionInfoRepository.findAll(), includeExpired));
        res.putAll(this.history(this.infoMap.values(), includeExpired));
        return res;
    }

    private Map<String, ExecutionStatus> history(Collection<CollectionInfo> infos, boolean includeExpired) {
        return infos.stream().filter(info -> includeExpired || info.getExecutionStatus() != ExecutionStatus.EXPIRED).collect(Collectors.toMap(CollectionInfo::getId, CollectionInfo::getExecutionStatus));
    }

    public static void cleanCollectedData(String storageUrl) throws URISyntaxException {
        log.info((Object)("[CLEAN] Deleting expired storage: " + storageUrl));
        URI uri = new URI(storageUrl);
        String protocol = uri.getScheme();
        String path = uri.getPath();
        File f = new File(path);
        if (protocol.equalsIgnoreCase("zip") && path.endsWith(".zip")) {
            f.delete();
        } else if (protocol.equalsIgnoreCase("file") && f.isDirectory()) {
            FileSystemUtils.deleteRecursively((File)f);
        }
    }

    @Transactional
    public void forceExpired() {
        this.collectionInfoRepository.forceExpirationDate(LocalDateTime.now());
    }
}

