/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.storage;

import eu.dnetlib.apps.oai.storage.StorageClient;
import eu.dnetlib.apps.oai.utils.SimpleUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalStorage
extends StorageClient {
    private static final Log log = LogFactory.getLog(LocalStorage.class);
    private long currentPage = -1L;
    private String rootDir;

    public LocalStorage(String jobId, URI storageBasePath) {
        super(jobId, storageBasePath);
        try {
            File d = new File(storageBasePath.getPath() + "/" + jobId);
            FileUtils.forceMkdir((File)d);
            this.rootDir = d.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException("Errore creating root dir", e);
        }
    }

    public void prepareCurrentPage(long page) {
        try {
            File d = new File(this.rootDir + "/" + SimpleUtils.pageToDir((long)page));
            FileUtils.forceMkdir((File)d);
            this.currentPage = page;
        }
        catch (IOException e) {
            throw new RuntimeException("Errore creating page", e);
        }
    }

    public void saveFile(String filename, String body) {
        try (FileWriter fw = new FileWriter(this.rootDir + "/" + SimpleUtils.pageToDir((long)this.currentPage) + "/" + filename);){
            IOUtils.write((String)body, (Writer)fw);
        }
        catch (IOException e) {
            log.error((Object)"Error saving info file");
            throw new RuntimeException("Error saving info file", e);
        }
    }
}

