/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.storage;

import eu.dnetlib.apps.oai.storage.FtpStorage;
import eu.dnetlib.apps.oai.storage.LocalStorage;
import eu.dnetlib.apps.oai.storage.StorageClient;
import eu.dnetlib.apps.oai.storage.ZipStorage;
import java.net.URI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class StorageClientFactory {
    @Value(value="${oai.conf.storage.basePath}")
    private URI storageBasePath;
    @Value(value="${oai.conf.storage.user}")
    private String storageUser;
    @Value(value="${oai.conf.storage.password}")
    private String storagePassword;

    public StorageClient newClient(String jobId) {
        String protocol = this.storageBasePath.getScheme();
        if (protocol.equalsIgnoreCase("ftp") || protocol.equalsIgnoreCase("ftps")) {
            return new FtpStorage(jobId, this.storageBasePath, this.storageUser, this.storagePassword);
        }
        if (protocol.equalsIgnoreCase("file")) {
            return new LocalStorage(jobId, this.storageBasePath);
        }
        if (protocol.equalsIgnoreCase("zip")) {
            return new ZipStorage(jobId, this.storageBasePath);
        }
        throw new RuntimeException("Invalid storage protocol: " + protocol + " (valid protocol are: file, ftp and ftps)");
    }
}

