/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.storage;

import eu.dnetlib.apps.oai.storage.StorageClient;
import eu.dnetlib.apps.oai.utils.SimpleUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipStorage
extends StorageClient {
    private static final Log log = LogFactory.getLog(ZipStorage.class);
    private FileOutputStream fos;
    private ZipOutputStream zipOut;
    private long currPage = -1L;

    public ZipStorage(String jobId, URI storageBasePath) {
        super(jobId, storageBasePath);
        try {
            File rootDir = new File(storageBasePath.getPath());
            FileUtils.forceMkdir((File)rootDir);
            this.fos = new FileOutputStream(rootDir.getAbsolutePath() + "/" + jobId + ".zip");
            this.zipOut = new ZipOutputStream(this.fos);
        }
        catch (IOException e) {
            throw new RuntimeException("Error preparing zip", e);
        }
    }

    public void complete() {
        try {
            if (this.zipOut != null) {
                this.zipOut.close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Ftp Disconnection Failed");
            throw new RuntimeException(e);
        }
    }

    public void prepareCurrentPage(long page) {
        try {
            this.zipOut.putNextEntry(new ZipEntry(SimpleUtils.pageToDir((long)page) + "/"));
            this.zipOut.closeEntry();
            this.currPage = page;
        }
        catch (IOException e) {
            throw new RuntimeException("Error adding a directory to zip", e);
        }
    }

    public void saveFile(String filename, String body) {
        try {
            this.zipOut.putNextEntry(new ZipEntry(new ZipEntry(SimpleUtils.pageToDir((long)this.currPage) + "/" + filename)));
            this.zipOut.write(body.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Error adding a file to zip", e);
        }
    }

    public String getStorageUrl() {
        return super.getStorageUrl() + ".zip";
    }
}

