/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.utils;

import eu.dnetlib.apps.oai.model.CollectionInfo;
import eu.dnetlib.apps.oai.model.ExecutionStatus;
import jakarta.annotation.PostConstruct;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Service
public class EmailSender {
    private static final Log log = LogFactory.getLog(EmailSender.class);
    private final BlockingQueue<Message> queue = new LinkedBlockingQueue();
    @Value(value="${oai.conf.app.public_url}")
    private String publicUrl;
    @Value(value="${oai.conf.notification.sender.name}")
    private String fromName;
    @Value(value="${oai.conf.notification.sender.email}")
    private String fromEmail;
    @Value(value="${oai.conf.notification.smtp.host}")
    private String smtpHost;
    @Value(value="${oai.conf.notification.smtp.port}")
    private long smtpPort;
    @Value(value="${oai.conf.notification.smtp.user}")
    private String smtpUser;
    @Value(value="${oai.conf.notification.smtp.password}")
    private String smtpPassword;
    @Autowired
    private TemplateEngine templateEngine;

    @PostConstruct
    public void init() {
        new Thread(() -> {
            block4: while (true) {
                try {
                    while (true) {
                        Message message;
                        if ((message = (Message)this.queue.take()) == null) {
                            continue;
                        }
                        try {
                            log.info((Object)"Sending mail...");
                            log.debug(message.getContent());
                            Transport.send((Message)message);
                            log.info((Object)"...sent");
                            continue block4;
                        }
                        catch (Throwable e) {
                            log.error((Object)"Error sending email", e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }).start();
    }

    public void sendNotification(CollectionInfo info) {
        if (StringUtils.isNotBlank((CharSequence)info.getNotificationEmail())) {
            String to = info.getNotificationEmail();
            if (info.getExecutionStatus() == ExecutionStatus.COMPLETED) {
                String subject = String.format("Success Notification: Metadata Collection Request (ID: %s)", info.getId());
                this.sendMail(to, subject, this.prepareMessage("email/success", info));
            } else {
                String subject = String.format("Failure Notification: Metadata Collection Request (ID: %s)", info.getId());
                this.sendMail(to, subject, this.prepareMessage("email/failure", info));
            }
        }
    }

    private String prepareMessage(String template, CollectionInfo info) {
        Context context = new Context();
        context.setVariable("info", (Object)info);
        context.setVariable("baseUrl", (Object)this.publicUrl);
        return this.templateEngine.process(template, (IContext)context);
    }

    public void sendMail(String to, String subject, String message) {
        try {
            Session session = Session.getInstance((Properties)this.obtainProperties(), (Authenticator)this.obtainAuthenticator());
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(this.fromEmail, this.fromName));
            mimeMessage.setSubject(subject);
            mimeMessage.setContent((Object)message, "text/html; charset=utf-8");
            mimeMessage.setSentDate(new Date());
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            this.queue.add(mimeMessage);
            log.info((Object)("Mail to " + to + " in queue (size=" + this.queue.size() + ")"));
        }
        catch (Exception e) {
            log.error((Object)"Error sending mail", (Throwable)e);
        }
    }

    private Properties obtainProperties() {
        Properties p = new Properties();
        p.put("mail.transport.protocol", "smtp");
        p.put("mail.smtp.host", this.smtpHost);
        p.put("mail.smtp.port", (Object)this.smtpPort);
        p.put("mail.smtp.auth", Boolean.toString(StringUtils.isNotBlank((CharSequence)this.smtpUser)));
        return p;
    }

    private Authenticator obtainAuthenticator() {
        if (StringUtils.isBlank((CharSequence)this.smtpUser)) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

