/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class SimpleUtils {
    private static final String UTF_8 = StandardCharsets.UTF_8.toString();
    private static final DateTimeFormatter oaiDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String generateNewJobId() {
        return "coll-" + UUID.randomUUID();
    }

    public static String oaiFirstUrl(String baseUrl, String format, String setSpec, LocalDateTime from, LocalDateTime until) {
        try {
            String url = baseUrl + "?verb=ListRecords&metadataPrefix=" + URLEncoder.encode(format, UTF_8);
            if (setSpec != null && !setSpec.isEmpty()) {
                url = url + "&set=" + URLEncoder.encode(setSpec, UTF_8);
            }
            if (from != null) {
                url = url + "&from=" + URLEncoder.encode(from.format(oaiDateFormatter), UTF_8);
            }
            if (until != null) {
                url = url + "&until=" + URLEncoder.encode(until.format(oaiDateFormatter), UTF_8);
            }
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String oaiNextUrl(String baseUrl, String rtoken) {
        try {
            if (StringUtils.isNotBlank((CharSequence)rtoken)) {
                return baseUrl + "?verb=ListRecords&resumptionToken=" + URLEncoder.encode(rtoken, UTF_8);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String oaiIdToFilename(String id) {
        return DigestUtils.md5Hex((String)id) + ".xml";
    }

    public static String pageToDir(long page) {
        return "page_" + StringUtils.leftPad((String)Long.toString(page), (int)4, (String)"0");
    }
}

