/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims;

import eu.dnetlib.claims.configuration.GlobalVars;
import eu.dnetlib.claims.service.MetricsService;
import eu.dnetlib.uoaauthorizationlibrary.SecurityConfiguration;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@EnableScheduling
@SpringBootApplication(scanBasePackages={"eu.dnetlib.claims"})
@PropertySources(value={@PropertySource(value={"classpath:application.properties"}), @PropertySource(value={"classpath:claims.properties"}), @PropertySource(value={"classpath:authorization.properties"}), @PropertySource(value={"classpath:dnet-override.properties"}, ignoreResourceNotFound=true)})
@Import(value={SecurityConfiguration.class})
@EnableConfigurationProperties(value={GlobalVars.class})
@EnableJpaRepositories(basePackages={"eu.dnetlib.claims.repository"})
public class Application {
    @Autowired
    MetricsService metricsService;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void calculateMetricsAtMidnight() {
        this.metricsService.calculateMetrics();
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void runEmailsAtMidnight() {
        System.out.println("emails: " + String.valueOf(new Date()));
    }
}

