/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.configuration;

import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PostgresConfig {
    @Value(value="${services.claims.db.password}")
    private String password;
    @Value(value="${services.claims.db.url}")
    private String url;
    @Value(value="${services.claims.db.username}")
    private String username;
    private static final Logger logger = LogManager.getLogger(PostgresConfig.class);

    @Bean
    public DataSource dataSource() {
        logger.info("Setting Postgres properties: " + this.url);
        return DataSourceBuilder.create().url(this.url).username(this.username).password(this.password).build();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

