/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.repository;

import eu.dnetlib.claims.controller.ClaimController;
import eu.dnetlib.claims.repository.ClaimRepositoryCustom;
import eu.dnetlib.claims.utils.QueryGenerator;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;

public class ClaimRepositoryCustomImpl
implements ClaimRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger logger = LogManager.getLogger(ClaimController.class);

    public Page<Object[]> findByCriteriaJoin(Pageable pageable, @Param(value="targetTypes") List<String> targetTypes, @Param(value="sourceTypes") List<String> sourceTypes, @Param(value="userMailPrefix") String userMailPrefix, @Param(value="sourceType") String sourceType, @Param(value="sourceId") String sourceId, @Param(value="dateFrom") Date dateFrom, @Param(value="dateTo") Date dateTo, String orderBy, Boolean desc, @Param(value="keyword") String keyword) {
        String queryStr = "SELECT c.id AS id, c.userMail as userMail, c.date as date, c.sourceType as sourceType, c.targetType as targetType, c.sourceId as sourceId, c.targetId as targetId, c.semantics as semantics, target.title as targetTitle, target.collectedFrom as targetCollectedFrom, sourceResult.title as sourceResultTitle, sourceProject.name as projectTitle, sourceProject.acronym as projectAcronym, sourceProject.funderName as projectFunderName, sourceProject.funderShortName as projectFunderShortName, sourceProject.funderId as projectFunderId, sourceContext.title as contextTitle, sourceOrganization.name as organizationTitle FROM Claim c  JOIN Result target on  c.targetId = target.openaireId   LEFT OUTER JOIN Project sourceProject on  c.sourceId = sourceProject.openaireId  LEFT OUTER JOIN Result sourceResult on  c.sourceId = sourceResult.openaireId  LEFT OUTER JOIN Context sourceContext on  c.sourceId = sourceContext.openaireId  LEFT OUTER JOIN Organization sourceOrganization on  c.sourceId = sourceOrganization.openaireId  WHERE (c.targetType IN :targetTypes OR c.sourceType IN :sourceTypes) AND c.userMail LIKE CONCAT(:userMailPrefix, '%') " + QueryGenerator.getSourceClause((String)sourceType, (String)sourceId) + QueryGenerator.getDateClause((Date)dateFrom, (Date)dateTo) + QueryGenerator.getWhereClause((String)keyword) + QueryGenerator.getOrderByClause((String)orderBy, (Boolean)desc) + QueryGenerator.getPagingClause((Integer)((int)pageable.getOffset()), (Integer)pageable.getPageSize());
        Query query = this.entityManager.createQuery(queryStr);
        query.setParameter("targetTypes", targetTypes);
        query.setParameter("sourceTypes", sourceTypes);
        query.setParameter("userMailPrefix", (Object)userMailPrefix);
        if (keyword.length() != 0) {
            query.setParameter("keyword", (Object)keyword);
        }
        if (sourceId != null && sourceType != null) {
            query.setParameter("sourceType", (Object)sourceType);
            query.setParameter("sourceId", (Object)sourceId);
        }
        if (dateFrom != null && dateTo != null) {
            query.setParameter("dateFrom", (Object)dateFrom);
            query.setParameter("dateTo", (Object)dateTo);
        }
        List results = query.getResultList();
        String countQueryStr = "select count(c)    FROM Claim c  JOIN Result target on  c.targetId = target.openaireId   LEFT OUTER JOIN Project sourceProject on  c.sourceId = sourceProject.openaireId  LEFT OUTER JOIN Result sourceResult on  c.sourceId = sourceResult.openaireId  LEFT OUTER JOIN Context sourceContext on  c.sourceId = sourceContext.openaireId  LEFT OUTER JOIN Organization sourceOrganization on  c.sourceId = sourceOrganization.openaireId  WHERE (c.targetType IN :targetTypes OR c.sourceType IN :sourceTypes) AND c.userMail LIKE CONCAT(:userMailPrefix, '%') " + QueryGenerator.getSourceClause((String)sourceType, (String)sourceId) + QueryGenerator.getDateClause((Date)dateFrom, (Date)dateTo) + QueryGenerator.getWhereClause((String)keyword);
        TypedQuery countQuery = this.entityManager.createQuery(countQueryStr, Long.class);
        countQuery.setParameter("targetTypes", targetTypes);
        countQuery.setParameter("sourceTypes", sourceTypes);
        countQuery.setParameter("userMailPrefix", (Object)userMailPrefix);
        if (keyword.length() != 0) {
            countQuery.setParameter("keyword", (Object)keyword);
        }
        if (sourceId != null && sourceType != null) {
            countQuery.setParameter("sourceType", (Object)sourceType);
            countQuery.setParameter("sourceId", (Object)sourceId);
        }
        if (dateFrom != null && dateTo != null) {
            countQuery.setParameter("dateFrom", (Object)dateFrom);
            countQuery.setParameter("dateTo", (Object)dateTo);
        }
        return new PageImpl(results, pageable, ((Long)countQuery.getSingleResult()).longValue());
    }
}

