/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.controller;

import eu.dnetlib.claims.model.Metrics;
import eu.dnetlib.claims.service.MetricsService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report"})
public class MetricsController {
    private static final Logger logger = LogManager.getLogger(MetricsController.class);
    @Autowired
    private MetricsService metricsService;

    public static void main(String[] args) {
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @GetMapping(value={"calc"})
    public String calculateMetrics() {
        this.metricsService.calculateMetrics();
        return "metrics calculated!";
    }

    @GetMapping(value={"/metrics"}, produces={"text/plain"})
    public String getSavedMetrics() {
        Metrics metrics = this.metricsService.getMetrics();
        String response = "";
        if (metrics != null) {
            response = metrics.getReport();
        }
        return response;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @GetMapping(value={"/metrics/now"}, produces={"text/plain"})
    public String getCurrentMetrics() {
        Metrics metrics = this.metricsService.getMetrics();
        String response = "";
        if (metrics != null) {
            response = metrics.getReport();
        }
        return response;
    }
}

