/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.ClaimDTO;
import eu.dnetlib.claims.model.Context;
import eu.dnetlib.claims.model.ManagerInfo;
import eu.dnetlib.claims.model.Notification;
import eu.dnetlib.claims.repository.ContextRepository;
import eu.dnetlib.claims.repository.NotificationRepository;
import eu.dnetlib.claims.service.ClaimService;
import eu.dnetlib.claims.service.ManagerUtilsService;
import jakarta.annotation.PostConstruct;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private static final Logger logger = LogManager.getLogger(EmailService.class);
    @Autowired
    ClaimService claimService;
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    ManagerUtilsService managerUtilsService;
    @Autowired
    ContextRepository contextRepository;
    private String defaultFrequencyInHours = "24";
    @Value(value="${services.claims.mail.manageCommunityUserNotificationsPage}")
    private String manageCommunityUserNotificationsPage;
    @Value(value="${services.claims.mail.openaireCommunityClaimsPage}")
    private String openaireCommunityClaimsPage;
    @Value(value="${services.claims.mail.username}")
    private String username;
    @Value(value="${services.claims.mail.password}")
    private String password;
    @Value(value="${services.claims.mail.host}")
    private String host;
    @Value(value="${services.claims.mail.port}")
    private String port;
    @Value(value="${services.claims.mail.from}")
    private String from;
    @Value(value="${services.claims.mail.auth}")
    private String auth;
    @Value(value="${services.claims.mail.sslProtocols:null}")
    private String sslProtocols;
    @Value(value="${services.claims.mail.contactMail}")
    private String contactMail;
    @Value(value="${services.claims.mail.specialRecipients}")
    private String specialRecipients;
    @Value(value="${services.claims.mail.enabledCommunities:null}")
    private String enabledCommunities;
    @Value(value="${services.claims.mail.notifyCommunityManagers}")
    private Boolean notifyCommunityManagers;
    private final Logger log = LogManager.getLogger(this.getClass());

    @PostConstruct
    public void checkProperties() {
        this.log.debug("Testing mail service...");
        if (this.specialRecipients != null && !this.specialRecipients.isEmpty()) {
            this.send("test", "Testing email", "community", Arrays.asList(this.specialRecipients.split("\\s*,\\s*")));
        } else {
            this.log.debug("No special recipients in properties...");
        }
    }

    public void run() {
        logger.info("EmailSender thread is running. " + this.host);
        logger.info("Special Recipients  " + this.specialRecipients);
        logger.info("Enabled Communities " + this.enabledCommunities);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateTo = new Date();
        String dateToStr = format.format(dateTo);
        if (this.notifyCommunityManagers.booleanValue()) {
            this.defaultEmails_For_CommunityClaims(dateTo, format);
            this.customNotificationEmails_For_CommunityClaims(dateTo, format);
        }
    }

    public void defaultEmails_For_CommunityClaims(Date dateTo, SimpleDateFormat format) {
        HashMap<String, List<String>> managersOfCommunity = new HashMap<String, List<String>>();
        List claims = null;
        ArrayList<String> types = new ArrayList<String>();
        types.add("context");
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -(Integer.parseInt(this.defaultFrequencyInHours) - 1));
        calendar.add(12, -59);
        calendar.add(13, -59);
        Date dateFrom = calendar.getTime();
        String dateFromStr = format.format(dateFrom);
        List<String> enabledCommunitiesList = null;
        if (this.enabledCommunities != null && !this.enabledCommunities.isEmpty()) {
            enabledCommunitiesList = Arrays.asList(this.enabledCommunities.split("\\s*,\\s*"));
        }
        logger.info("Sending emails for community claims between " + dateFromStr + " and " + String.valueOf(dateTo));
        claims = this.claimService.getClaimsFromTo((Pageable)PageRequest.of((int)0, (int)1000), Boolean.valueOf(false), "", types, "date", Boolean.valueOf(true), "", dateFrom, dateTo, null, null).getData();
        logger.info(claims.size() + " new claims found");
        for (ClaimDTO claim : claims) {
            if (!claim.getSourceType().equals("context")) continue;
            Context context = (Context)claim.getSource();
            String openaireId = context.getOpenaireId().split("::")[0];
            System.out.println("Context claim: " + openaireId);
            if (!managersOfCommunity.containsKey(openaireId) && (enabledCommunitiesList == null || enabledCommunitiesList.contains(openaireId))) {
                List<String> tmpManagers = null;
                if (this.specialRecipients != null && !this.specialRecipients.isEmpty()) {
                    tmpManagers = Arrays.asList(this.specialRecipients.split("\\s*,\\s*"));
                    logger.info("Special recipients: " + this.specialRecipients);
                    managersOfCommunity.put(openaireId, tmpManagers);
                }
                ArrayList<String> managers = new ArrayList<String>();
                List managersInfo = this.managerUtilsService.getManagersByEmail(openaireId);
                System.out.println(managersInfo);
                if (managersInfo != null) {
                    for (ManagerInfo manager : managersInfo) {
                        String managerMail = manager.getEmail();
                        Notification notification = this.notificationRepository.findByOpenaireIdAndUserMail(openaireId, managerMail);
                        if (notification == null) {
                            managers.add(managerMail);
                            continue;
                        }
                        logger.info("Custom mailto be sent to community manager: " + managerMail);
                    }
                } else {
                    logger.info("Community Managers: null");
                }
                logger.info("Managers of community " + openaireId + ": " + String.valueOf(managers));
                managersOfCommunity.put(openaireId, managers);
                if (managersOfCommunity.get(openaireId) == null || ((List)managersOfCommunity.get(openaireId)).isEmpty()) continue;
                this.send(openaireId, context.getTitle().split(">")[0], "community", (List)managersOfCommunity.get(openaireId));
                continue;
            }
            if (enabledCommunitiesList == null || enabledCommunitiesList.contains(openaireId)) continue;
            logger.info("Community " + openaireId + " is not enabled");
        }
    }

    public void customNotificationEmails_For_CommunityClaims(Date dateTo, SimpleDateFormat format) {
        Context context = null;
        ArrayList<String> types = new ArrayList<String>();
        types.add("context");
        List<String> enabledCommunitiesList = null;
        if (this.enabledCommunities != null && !this.enabledCommunities.isEmpty()) {
            enabledCommunitiesList = Arrays.asList(this.enabledCommunities.split("\\s*,\\s*"));
        }
        logger.info("Sending email for community claims from notification table");
        try {
            List trueNotifications = this.notificationRepository.findByNotify(Boolean.valueOf(true));
            HashMap allManagers = new HashMap();
            if (trueNotifications != null) {
                for (Notification notification : trueNotifications) {
                    if (enabledCommunitiesList == null || enabledCommunitiesList.contains(notification.getOpenaireId())) {
                        if (!allManagers.containsKey(notification.getOpenaireId())) {
                            allManagers.put(notification.getOpenaireId(), new ArrayList());
                            ArrayList<ManagerInfo> managersInfo = this.managerUtilsService.getManagersByEmail(notification.getOpenaireId());
                            managersInfo = new ArrayList<ManagerInfo>();
                            ManagerInfo testManager = new ManagerInfo();
                            testManager.setEmail("argirok@di.uoa.gr");
                            testManager.setName("Argiro");
                            managersInfo.add(testManager);
                            if (managersInfo != null) {
                                for (ManagerInfo manager : managersInfo) {
                                    ((List)allManagers.get(notification.getOpenaireId())).add(manager.getEmail());
                                }
                            }
                        }
                        if (((List)allManagers.get(notification.getOpenaireId())).contains(notification.getUserMail())) {
                            Date _last_interaction_date = notification.getLastInteractionDate();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(_last_interaction_date);
                            cal.add(13, 1);
                            _last_interaction_date = cal.getTime();
                            String last_interaction_date = format.format(_last_interaction_date);
                            long diff = dateTo.getTime() - notification.getLastInteractionDate().getTime();
                            if ((diff /= 1000L) >= (long)(notification.getFrequency() * 3600)) {
                                if (this.claimService.getClaimsFromTo((Pageable)PageRequest.of((int)0, (int)1000), Boolean.valueOf(false), "", types, "date", Boolean.valueOf(true), "", _last_interaction_date, dateTo, "context", notification.getOpenaireId()).getTotalElements() > 0L) {
                                    ArrayList<String> managersByNotification = new ArrayList<String>();
                                    managersByNotification.add(notification.getUserMail());
                                    context = this.contextRepository.findByOpenaireId(notification.getOpenaireId());
                                    logger.info("Sending email for community claims between " + last_interaction_date + " and " + String.valueOf(dateTo) + " to " + notification.getUserMail());
                                    this.send(context.getOpenaireId().split("::")[0], context.getTitle().split(">")[0], "community", managersByNotification);
                                }
                                this.updateNotification(notification.getOpenaireId(), notification.getUserMail(), dateTo);
                                continue;
                            }
                            logger.info("[no notification] User " + notification.getUserMail() + " got latest notification at " + last_interaction_date + " and has set frequency to: " + notification.getFrequency());
                            continue;
                        }
                        logger.info("User " + notification.getUserMail() + " is not manager of community " + notification.getOpenaireId());
                        continue;
                    }
                    logger.info("Community " + notification.getOpenaireId() + " is not enabled");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(String openaire_id, String openaire_name, String type, List<String> managers) {
        logger.info("Sending email");
        String openaireClaimsPageUrl = "";
        String manageUserNotificationsPage = "";
        Object messageContent = "";
        Object subject = "";
        openaireClaimsPageUrl = this.openaireCommunityClaimsPage.replace("{community}", openaire_id);
        manageUserNotificationsPage = this.manageCommunityUserNotificationsPage.replace("{community}", openaire_id);
        subject = "[OpenAIRE-Connect] " + openaire_name + ": Links notification";
        messageContent = " <div style=\"font-size:14px;\">    <p>       There are new links for '" + openaire_name + "' community. Click  <a href=\"" + openaireClaimsPageUrl + "\">here</a> to view the links.\n    </p>    <p>OpenAIRE team<br/>       <a href=\"https://www.openaire.eu\">www.openaire.eu</a>    </p>    <p style=\"font-size:11px;\">You are receiving this e-mail as manager of the community  <a href=\"https://" + openaire_id + ".openaire.eu\">" + openaire_name + "</a>.    If you are not responsible for this community, please <a href=\"mailto:" + this.contactMail + "\">contact us</a>.    <br/>    Click  <a href=\"" + manageUserNotificationsPage + "\">here</a> to manage your notification settings. </p>    </div>";
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.host);
        properties.put("mail.smtp.port", this.port);
        properties.put("mail.smtp.auth", this.auth);
        properties.put("mail.smtp.starttls.enable", "true");
        if (this.sslProtocols != null) {
            properties.put("mail.smtp.ssl.protocols", this.sslProtocols);
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.from));
            for (String to : managers) {
                logger.info(to);
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            }
            message.setSubject((String)subject);
            message.setContent(messageContent, "text/html");
            Transport.send((Message)message);
            logger.info("Sent message successfully....\n");
        }
        catch (AddressException ae) {
            logger.error("Email could not be send.", (Throwable)ae);
        }
        catch (MessagingException me) {
            logger.error("Email could not be send.", (Throwable)me);
        }
    }

    public Notification updateNotification(String openaireId, String mail, Date date) {
        Notification notification = this.notificationRepository.findByOpenaireIdAndUserMail(openaireId, mail);
        notification.setLastInteractionDate(date);
        return (Notification)this.notificationRepository.save((Object)notification);
    }
}

