/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.controller;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.claims.handler.UnAuthorizedException;
import eu.dnetlib.claims.model.Claim;
import eu.dnetlib.claims.model.ClaimDTO;
import eu.dnetlib.claims.model.ClaimToSave;
import eu.dnetlib.claims.model.Job;
import eu.dnetlib.claims.model.Notification;
import eu.dnetlib.claims.model.PageDTO;
import eu.dnetlib.claims.model.ResponseDTO;
import eu.dnetlib.claims.service.ClaimService;
import eu.dnetlib.claims.service.FeedInGraphService;
import eu.dnetlib.claims.service.NotificationService;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/claimsService"})
public class ClaimController {
    @Autowired
    private ClaimService claimService;
    @Autowired
    private FeedInGraphService feedInGraphService;
    @Autowired
    private AuthorizationService authorizationService;
    @Autowired
    private NotificationService notificationService;
    private static final Logger logger = LogManager.getLogger(ClaimController.class);
    private BlockingQueue<Job> jobQueue = new LinkedBlockingQueue();
    private ExecutorService executorService;
    private List<Job> jobWorkingOrCompleted = Collections.synchronizedList(new ArrayList());

    ClaimController() {
        this.executorService = Executors.newFixedThreadPool(10);
        this.executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"jobStatus/{jobId}"})
    public String getJobStatus(@PathVariable(value="jobId") String jobId) {
        Job foundJob = null;
        List list = this.jobWorkingOrCompleted;
        synchronized (list) {
            for (Job job : this.jobWorkingOrCompleted) {
                if (!job.getId().equals(jobId)) continue;
                foundJob = job;
            }
        }
        for (Job job : this.jobQueue) {
            if (!job.getId().equals(jobId)) continue;
            foundJob = job;
        }
        System.out.println(foundJob);
        if (foundJob != null) {
            return this.composeMessage("success", "200", "Job status is " + String.valueOf(foundJob.getStatus()), null, ", \"data\":" + new Gson().toJson((Object)foundJob));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Job not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('claim'))")
    @GetMapping(value={"jobsStatus"}, produces={"text/html; charset=utf-8"})
    public String getJobsStatus() {
        Date d = new Date();
        String s = "Job  completed/ working size:" + this.jobWorkingOrCompleted.size() + "<br>";
        List list = this.jobWorkingOrCompleted;
        synchronized (list) {
            for (Job job : this.jobWorkingOrCompleted) {
                s = s + job.getId() + " Job status: " + String.valueOf(job.getStatus()) + " " + String.valueOf(job.getCreatedAt()) + "<br>";
            }
        }
        s = s + "Job size:" + this.jobQueue.size() + "<br>";
        s = s + "remainingCapacity: " + this.jobQueue.remainingCapacity() + "<br>";
        for (Job job : this.jobQueue) {
            s = s + job.getId() + " Job status: " + String.valueOf(job.getStatus()) + " " + String.valueOf(job.getCreatedAt()) + "<br>";
        }
        s = s + "<br>" + String.valueOf(d);
        return s;
    }

    @PreAuthorize(value="isAuthenticated()")
    @PostMapping(value={"/claims/bulk"})
    public String createBulkClaimsJob(@RequestBody List<ClaimToSave> claimsToSave) {
        Job job = new Job();
        job.setType(Job.TYPE.CLAIM);
        job.setClaimsToSave(claimsToSave);
        job.setUser(this.authorizationService.getEmail());
        this.jobQueue.add(job);
        logger.debug("submit job " + job.getId());
        return this.composeMessage("success", "200", "job submitted!", null, ", \"data\" : " + new Gson().toJson((Object)job));
    }

    private void addBulkClaims(Job job) {
        int code200 = 0;
        int code400 = 0;
        int code500 = 0;
        for (ClaimToSave claimToSave : job.getClaimsToSave()) {
            Integer claimId = this.claimService.buildAndInsertClaim(claimToSave, job.getUser());
            if (claimId != null) {
                job.getInsertedIds().add("" + claimId);
                ++code200;
                continue;
            }
            job.getErrorInClaims().add(claimToSave);
            ++code400;
        }
        if (job.getClaimsToSave().size() == code500) {
            job.setCode(Integer.valueOf(500));
            job.setMessage("Fail to add new claims");
        } else if (code200 > 0) {
            job.setCode(Integer.valueOf(200));
            job.setMessage("ok");
        } else {
            job.setCode(Integer.valueOf(400));
            job.setMessage("claims not saved for some ids");
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @PostMapping(value={"/feed/bulk"})
    public String createBulkRecordsJob(@RequestBody String input) {
        Job job = new Job();
        job.setType(Job.TYPE.FEED);
        job.setInputArray(new JsonParser().parse(input).getAsJsonArray());
        job.setUser(this.authorizationService.getEmail());
        this.jobQueue.add(job);
        logger.debug("submit job " + job.getId());
        return this.composeMessage("success", "200", "job submitted!", null, ", \"data\" : " + new Gson().toJson((Object)job));
    }

    private void feedBulkRecords(Job job) {
        int code200 = 0;
        int code400 = 0;
        int code500 = 0;
        for (JsonElement je : job.getInputArray()) {
            JsonObject jsonObject = je.getAsJsonObject();
            System.out.println(new Gson().toJson(jsonObject.get("record")));
            Boolean inserted = this.feedInGraphService.feedIndex(new Gson().toJson(jsonObject.get("record")));
            if (inserted.booleanValue()) {
                job.getInsertedIds().add(jsonObject.get("id").getAsString());
                ++code200;
                continue;
            }
            ++code400;
        }
        if (job.getInputArray().size() == code500) {
            job.setCode(Integer.valueOf(500));
            job.setMessage("Fail to add new claims");
        } else if (code200 > 0) {
            job.setCode(Integer.valueOf(200));
            job.setMessage("ok");
        } else {
            job.setCode(Integer.valueOf(400));
            job.setMessage("some records couldn't be saved");
        }
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('claim'))")
    @GetMapping(value={"/claims"})
    public PageDTO<ClaimDTO> getAllClaims(@RequestParam(name="offset", defaultValue="0") Integer offset, @RequestParam(name="limit", defaultValue="20") Integer limit, @RequestParam(name="keyword", defaultValue="") String keyword, @RequestParam(name="orderby", defaultValue="date") String orderby, @RequestParam(name="descending", defaultValue="true") boolean descending, @RequestParam(name="types", defaultValue="") ArrayList<String> types, @RequestParam(name="mine", defaultValue="false") Boolean mine) {
        PageRequest pageable = PageRequest.of((int)offset, (int)limit);
        return this.claimService.getClaims((Pageable)pageable, mine, this.authorizationService.getEmail(), types, orderby, Boolean.valueOf(descending), keyword);
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"/users/claims"})
    public PageDTO<ClaimDTO> getUserClaims(@RequestParam(name="offset", defaultValue="0") Integer offset, @RequestParam(name="limit", defaultValue="20") Integer limit, @RequestParam(name="keyword", defaultValue="") String keyword, @RequestParam(name="orderby", defaultValue="date") String orderby, @RequestParam(name="descending", defaultValue="true") boolean descending, @RequestParam(name="types", defaultValue="") ArrayList<String> types) {
        PageRequest pageable = PageRequest.of((int)offset, (int)limit);
        return this.claimService.getClaims((Pageable)pageable, Boolean.valueOf(true), this.authorizationService.getEmail(), types, orderby, Boolean.valueOf(descending), keyword);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('claim'), @AuthorizationService.manager('INSTITUTION',#organizationId), @AuthorizationService.curator('INSTITUTION'))")
    @GetMapping(value={"/organizations/{organizationId}/claims"})
    public PageDTO<ClaimDTO> getOrganizationClaims(@PathVariable(value="organizationId") String organizationId, @RequestParam(name="offset", defaultValue="0") Integer offset, @RequestParam(name="limit", defaultValue="20") Integer limit, @RequestParam(name="keyword", defaultValue="") String keyword, @RequestParam(name="orderby", defaultValue="date") String orderby, @RequestParam(name="descending", defaultValue="true") boolean descending, @RequestParam(name="types", defaultValue="") ArrayList<String> types, @RequestParam(name="mine", defaultValue="false") Boolean mine) {
        PageRequest pageable = PageRequest.of((int)offset, (int)limit);
        return this.claimService.getClaimsBySource((Pageable)pageable, mine, this.authorizationService.getEmail(), types, orderby, Boolean.valueOf(descending), keyword, "organization", organizationId);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('claim'), @AuthorizationService.manager('COMMUNITY',#contextId), @AuthorizationService.curator('COMMUNITY'), @AuthorizationService.manager('RI',#contextId), @AuthorizationService.curator('RI'))")
    @GetMapping(value={"/contexts/{contextId}/claims"})
    public PageDTO<ClaimDTO> getContextClaims(@PathVariable(value="contextId") String contextId, @RequestParam(name="offset", defaultValue="0") Integer offset, @RequestParam(name="limit", defaultValue="20") Integer limit, @RequestParam(name="keyword", defaultValue="") String keyword, @RequestParam(name="orderby", defaultValue="date") String orderby, @RequestParam(name="descending", defaultValue="true") boolean descending, @RequestParam(name="types", defaultValue="") ArrayList<String> types, @RequestParam(name="mine", defaultValue="false") Boolean mine) {
        PageRequest pageable = PageRequest.of((int)offset, (int)limit);
        return this.claimService.getClaimsBySource((Pageable)pageable, mine, this.authorizationService.getEmail(), types, orderby, Boolean.valueOf(descending), keyword, "context", contextId);
    }

    @PreAuthorize(value="isAuthenticated()")
    @DeleteMapping(value={"/claims/bulk"})
    public String deleteBulkClaims(@RequestParam(value="claimId") List<String> claimId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<Integer> deletedIds = new ArrayList<Integer>();
        ArrayList<Integer> notFoundIds = new ArrayList<Integer>();
        if (!(claimId != null && claimId.size() != 0 || ids != null && ids.size() != 0)) {
            return this.composeMessage("error", "404", "Claim ids cannot be empty.", null, null);
        }
        if (ids == null) {
            ids = new ArrayList();
        }
        for (String string : claimId) {
            ids.add(Integer.parseInt(string));
        }
        logger.debug("Trying to delete claims with ids: " + claimId.toString() + ".");
        for (Integer n : ids) {
            try {
                Claim claim = this.claimService.getClaimById(n);
                if (claim != null) {
                    if (this.claimService.canUserDeleteClaim(claim).booleanValue()) {
                        System.out.println(claim.getClaimedInDashboard());
                        this.claimService.deleteClaim(claim);
                        deletedIds.add(n);
                        continue;
                    }
                    throw new UnAuthorizedException("User " + this.authorizationService.getEmail() + " has no authority to delete claim " + claim.getId() + " " + claim.getSourceType() + " " + claim.getSourceId() + " " + claim.getClaimedInDashboard());
                }
                notFoundIds.add(n);
            }
            catch (Exception e) {
                logger.error("Fail to delete claim with id " + n + ".", (Throwable)e);
                notFoundIds.add(n);
            }
        }
        logger.debug("Successfully deleted " + deletedIds.size() + " from " + claimId.size() + ". Deleted claims with ids: " + deletedIds.toString() + ".");
        if (ids.size() == notFoundIds.size()) {
            return this.composeMessage("error", "404", "Claim ids cannot be empty.", null, null);
        }
        if (claimId.size() == notFoundIds.size()) {
            return this.composeBulkDeleteMessage("success", "204", deletedIds, notFoundIds);
        }
        return this.composeBulkDeleteMessage("success", "200", deletedIds, notFoundIds);
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"/{id}"})
    public Claim getClaimById(@PathVariable(value="id") Integer id) {
        return this.claimService.getClaimById(id);
    }

    private String composeBulkDeleteMessage(String status, String code, List<Integer> deletedIds, List<Integer> notFoundIds) {
        return this.composeMessage(status, code, "", null, ",\"deletedIds\" : " + new Gson().toJson(deletedIds) + ",\"notFoundIds\" : " + new Gson().toJson(notFoundIds));
    }

    private String composeMessage(String status, String code, String message, String description, String data) {
        return "{ \"status\" : \"" + status + "\", \"code\" : \"" + code + "\", \"message\" : \"  " + message + " \"" + (String)(description != null ? ", \"description\" : \"" + description + " \"" : "") + (data != null ? data : "") + " }";
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"users/notification"})
    public ResponseDTO<Notification> getUserEmailNotificationPreferences(@RequestParam(name="communityId", required=true) String communityId) {
        String userMail = this.authorizationService.getEmail();
        ArrayList<Notification> notifications = null;
        Notification notification = this.notificationService.getNotificationByMailAndCommunity(userMail, communityId);
        if (notification != null) {
            notifications = new ArrayList<Notification>();
            notifications.add(notification);
            ResponseDTO responseDTO = new ResponseDTO(notifications, "success", "200");
            return responseDTO;
        }
        throw new NotFoundException("There are no notifications for " + userMail + " and community " + communityId);
    }

    @PreAuthorize(value="isAuthenticated()")
    @PostMapping(value={"/users/notification/save"})
    public Boolean saveOrUpdateUserEmailNotificationPreferences(@RequestBody Notification notification) {
        String userMail = this.authorizationService.getEmail();
        notification.setUserMail(userMail);
        notification.setLastInteractionDate(new Date());
        this.notificationService.saveNotification(notification);
        return true;
    }
}

