/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.repository;

import eu.dnetlib.claims.model.Claim;
import eu.dnetlib.claims.repository.ClaimRepositoryCustom;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface ClaimRepository
extends JpaRepository<Claim, Integer>,
ClaimRepositoryCustom {
    public Integer countClaimBySourceId(String var1);

    public Integer countClaimByTargetId(String var1);

    @Query(value="SELECT COUNT(DISTINCT c.userMail) FROM Claim c")
    public Integer countUserMails();

    @Query(value="SELECT COUNT(DISTINCT c.sourceId) FROM Claim c where c.sourceType = 'project'")
    public Integer countProjects();

    @Query(value="SELECT COUNT(DISTINCT c.sourceId) FROM Claim c where c.sourceType = 'publication' or c.sourceType = 'dataset'  or c.sourceType = 'software'  or c.sourceType = 'other' ")
    public Integer countResults();

    @Query(value="SELECT COUNT(DISTINCT regexp_replace(c.userMail,'^.*\\.', '')) FROM Claim c")
    public Integer countCountries();

    @Query(value="SELECT   COUNT(c) FROM Claim c  JOIN Project sourceProject on  c.sourceId = sourceProject.openaireId where c.sourceType = 'project'  AND sourceProject.funderShortName = 'EC'")
    public Integer countEUProjects();

    @Query(value="SELECT c.claimedInDashboard, COUNT(c) FROM Claim c GROUP BY c.claimedInDashboard")
    public List<Object[]> countGroupByDashboard();

    @Query(value="SELECT  c.claimedInDashboard, COUNT(DISTINCT c.userMail) FROM Claim c GROUP BY c.claimedInDashboard")
    public List<Object[]> countUserMailsByDashboard();

    @Query(value="SELECT  c.claimedInDashboard, COUNT(DISTINCT c.sourceId) FROM Claim c where c.sourceType = 'project' GROUP BY c.claimedInDashboard")
    public List<Object[]> countProjectsByDashboard();

    @Query(value="SELECT  c.claimedInDashboard, COUNT(DISTINCT c.sourceId) FROM Claim c where c.sourceType = 'publication' or c.sourceType = 'dataset'  or c.sourceType = 'software'  or c.sourceType = 'other' GROUP BY c.claimedInDashboard")
    public List<Object[]> countResultsByDashboard();

    @Query(value="SELECT  c.claimedInDashboard, COUNT(DISTINCT regexp_replace(c.userMail,'^.*\\.', '')) FROM Claim c GROUP BY c.claimedInDashboard")
    public List<Object[]> countCountriesByDashboard();

    @Query(value="SELECT  c.claimedInDashboard,  COUNT(DISTINCT c.sourceId), sourceProject.funderShortName FROM Claim c  JOIN Project sourceProject on  c.sourceId = sourceProject.openaireId where c.sourceType = 'project'  AND sourceProject.funderShortName = 'EC' GROUP BY c.claimedInDashboard,sourceProject.funderShortName")
    public List<Object[]> countEUProjectsByDashboard();
}

