/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.Result;
import eu.dnetlib.claims.service.ClaimService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HandleRecordFileService {
    @Value(value="${services.claims.results.pathToSaveRecord}")
    String pathToSaveRecord;
    private static final Logger logger = LogManager.getLogger(ClaimService.class);

    private Boolean createFile(String path, String fileName, String content) {
        Path fullPath = Paths.get(path, fileName);
        Path directoryPath = Paths.get(path, new String[0]);
        try {
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            if (!Files.exists(fullPath, new LinkOption[0])) {
                Files.writeString(fullPath, (CharSequence)content, StandardOpenOption.CREATE_NEW);
                logger.debug("Save File: " + path + "/" + fileName);
                return true;
            }
            logger.warn("File exists: " + path + " " + fileName);
            return false;
        }
        catch (IOException e) {
            logger.error("fail to save ", (Throwable)e);
            return false;
        }
    }

    public String exportMetadataFileForResult(Result result) {
        if (result.getOpenaireId() != null && result.getMetadataRecord() != null) {
            String path = this.createExportPath(result.getResultType(), result.getCollectedFrom());
            Boolean saved = this.createFile(path, result.getOpenaireId(), result.getMetadataRecord());
            return saved != false ? this.getFullExportPath(result.getResultType(), result.getCollectedFrom(), result.getOpenaireId()).split(this.pathToSaveRecord)[1] : null;
        }
        return null;
    }

    private String createExportPath(String type, String collectedFrom) {
        String datasource = "openaire";
        if (collectedFrom.equals("openaire____::orcid")) {
            datasource = "orcid";
        } else if (collectedFrom.equals("openaire____::crossref")) {
            datasource = "crossref";
        } else if (collectedFrom.equals("openaire____::datacite")) {
            datasource = "datacite";
        }
        return this.pathToSaveRecord + type + "/" + datasource;
    }

    private String getFullExportPath(String type, String collectedFrom, String openaireId) {
        return this.createExportPath(type, collectedFrom) + "/" + openaireId.replace("/", "*");
    }

    public Boolean deleteRecordFile(String type, String source, String id) {
        if (source == null) {
            logger.warn("couldn't recreate path for " + type + " with " + id);
            return false;
        }
        String path = this.createExportPath(type, source);
        File file = new File(path + "/" + id);
        if (file.delete()) {
            logger.info("Delete file: " + path + "/" + id);
            return true;
        }
        logger.error("Delete operation is failed for file " + this.pathToSaveRecord + path + "/" + id);
        return false;
    }
}

