/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.Metrics;
import eu.dnetlib.claims.repository.ClaimRepository;
import eu.dnetlib.claims.repository.MetricsRepository;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsService {
    @Autowired
    private ClaimRepository claimRepository;
    @Autowired
    private MetricsRepository metricsRepository;
    private static final Logger logger = LogManager.getLogger(MetricsService.class);

    public void calculateMetrics() {
        System.out.println("calculating...." + String.valueOf(new Date()));
        Metrics metrics = this.createMetrics();
        this.metricsRepository.save((Object)metrics);
    }

    public Metrics getMetrics() {
        logger.info("Fetching metrics...");
        return this.metricsRepository.findById((Object)"new-api").orElse(null);
    }

    public Metrics createMetrics() {
        Metrics metrics = new Metrics();
        metrics.setDate(new Date());
        metrics.setId("new-api");
        Map claims = this.responseToMetricDetails(this.claimRepository.countGroupByDashboard());
        Map users = this.responseToMetricDetails(this.claimRepository.countUserMailsByDashboard());
        Map countries = this.responseToMetricDetails(this.claimRepository.countCountriesByDashboard());
        Map projects = this.responseToMetricDetails(this.claimRepository.countProjectsByDashboard());
        Map results = this.responseToMetricDetails(this.claimRepository.countResultsByDashboard());
        Map eu_projects = this.responseToMetricDetails(this.claimRepository.countEUProjectsByDashboard());
        StringBuilder report = new StringBuilder("# TYPE claims_recorded gauge\n");
        for (Metrics.MetricDetails details : claims.values()) {
            report.append("claims_recorded{environment=\"").append(details.getEnvironment()).append("\", portal=\"").append(details.getDashboard()).append("\"} ").append(details.getNumber()).append("\n");
        }
        report.append("# TYPE claims_users gauge\n");
        for (Metrics.MetricDetails details : users.values()) {
            report.append("claims_users{environment=\"").append(details.getEnvironment()).append("\", portal=\"").append(details.getDashboard()).append("\"} ").append(details.getNumber()).append("\n");
        }
        report.append("# TYPE claims_projects gauge\n");
        for (Metrics.MetricDetails details : projects.values()) {
            report.append("claims_projects{environment=\"").append(details.getEnvironment()).append("\", portal=\"").append(details.getDashboard()).append("\"} ").append(details.getNumber()).append("\n");
        }
        report.append("# TYPE claims_eu_projects gauge\n");
        for (Metrics.MetricDetails details : eu_projects.values()) {
            report.append("claims_eu_projects{environment=\"").append(details.getEnvironment()).append("\", portal=\"").append(details.getDashboard()).append("\"} ").append(details.getNumber()).append("\n");
        }
        report.append("# TYPE claims_countries gauge\n");
        for (Metrics.MetricDetails details : countries.values()) {
            report.append("claims_countries{environment=\"").append(details.getEnvironment()).append("\", portal=\"").append(details.getDashboard()).append("\"} ").append(details.getNumber()).append("\n");
        }
        report.append("# TYPE claims_unique_research_results gauge\n");
        for (Metrics.MetricDetails details : results.values()) {
            report.append("claims_unique_research_results{environment=\"").append(details.getEnvironment()).append("\", portal=\"").append(details.getDashboard()).append("\"} ").append(details.getNumber()).append("\n");
        }
        report.append("claims_last_metrics_updater_run_timestamp_seconds ").append(metrics.getDate().getTime() / 1000L).append("\n");
        metrics.setReport(report.toString());
        return metrics;
    }

    private Map<String, Metrics.MetricDetails> responseToMetricDetails(List<Object[]> list) {
        HashMap<String, Metrics.MetricDetails> metricsMap = new HashMap<String, Metrics.MetricDetails>();
        for (Object[] o : list) {
            Metrics.MetricDetails metrics = new Metrics.MetricDetails();
            String claimedInDashbaord = (String)o[0];
            if (claimedInDashbaord != null) {
                metrics.setEnvironment(claimedInDashbaord.split("_")[0]);
                metrics.setDashboard(claimedInDashbaord.split(claimedInDashbaord.split("_")[0] + "_")[1]);
            }
            metrics.setNumber(((Long)o[1]).longValue());
            metricsMap.put(claimedInDashbaord, metrics);
        }
        return metricsMap;
    }
}

