/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.parser;

import com.google.gson.Gson;
import eu.dnetlib.claims.model.Result;
import eu.dnetlib.claims.parser.CrossrefResponse;
import eu.dnetlib.claims.parser.DataciteResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExternalRecordParser {
    private static final Logger logger = LogManager.getLogger(ExternalRecordParser.class);

    public static Result crossref2Result(String json, String idSuffix) {
        Result result = null;
        if (json == null) {
            return result;
        }
        Gson gson = new Gson();
        BufferedReader br = new BufferedReader(new StringReader(json));
        CrossrefResponse obj = (CrossrefResponse)gson.fromJson((Reader)br, CrossrefResponse.class);
        if (obj != null && obj.getMessage().getItems().size() > 0) {
            result = new Result();
            result.setMetadataRecord(json);
            result.setRecordFormat("json");
            result.setCollectedFrom("openaire____::crossref");
            CrossrefResponse.Message.Item item = (CrossrefResponse.Message.Item)obj.getMessage().getItems().get(0);
            if (item.getTitle() != null && item.getTitle().size() > 0) {
                result.setTitle((String)item.getTitle().get(0));
            }
            result.setDoi(item.getDOI());
            result.setOpenaireId(ExternalRecordParser.createOpenaireId((String)(item.getDOI() + idSuffix)));
            result.setExternalUrl(item.getUrl());
            if (result.getDoi() != null && result.getExternalUrl() == null) {
                result.setExternalUrl("https://dx.doi.org/" + result.getDoi());
            }
            result.setResultType("publication");
        }
        return result;
    }

    public static Result dataciteJson2Result(String json, String idSuffix) {
        Result result = null;
        if (json == null) {
            return result;
        }
        BufferedReader br = new BufferedReader(new StringReader(json));
        Gson gson = new Gson();
        DataciteResponse obj = (DataciteResponse)gson.fromJson((Reader)br, DataciteResponse.class);
        System.out.println(json);
        if (obj != null && obj.getData() != null) {
            result = new Result();
            result.setMetadataRecord(json);
            result.setRecordFormat("json");
            result.setCollectedFrom("openaire____::datacite");
            DataciteResponse.Data.Attributes item = obj.getData().getAttributes();
            if (item.getTitle() != null) {
                result.setTitle(item.getTitle());
            }
            System.out.println(item.getDoi());
            result.setDoi(item.getDoi());
            result.setOpenaireId(ExternalRecordParser.createOpenaireId((String)(item.getDoi() + idSuffix)));
            if (result.getDoi() != null && result.getExternalUrl() == null) {
                result.setExternalUrl("https://dx.doi.org/" + result.getDoi());
            }
            result.setResultType("dataset");
        }
        return result;
    }

    public static Result orcid2Result(String xml, String orcidworkid, String idSuffix) {
        Result result = null;
        if (xml == null || orcidworkid == null) {
            return result;
        }
        String orcidwork = orcidworkid.substring(20, orcidworkid.length());
        System.out.println();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            Document document = dBuilder.parse(is);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            System.out.println(orcidwork);
            NodeList worknl = (NodeList)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']").evaluate(document, XPathConstants.NODESET);
            for (int n = 0; n < worknl.getLength(); ++n) {
                int i;
                String code = (String)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']/@put-code").evaluate(worknl.item(n), XPathConstants.STRING);
                result = new Result();
                result.setResultType("publication");
                NodeList nl = (NodeList)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']/*[name()='work:title']/*[name()='common:title']/text()").evaluate(worknl.item(n), XPathConstants.NODESET);
                if (nl.getLength() > 0) {
                    result.setTitle(nl.item(0).getNodeValue());
                }
                nl = (NodeList)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']//*[name()='common:external-id']").evaluate(worknl.item(n), XPathConstants.NODESET);
                for (i = 0; i < nl.getLength(); ++i) {
                    String type = null;
                    String id = null;
                    NodeList identifiersNl = (NodeList)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']//*[name()='common:external-id-type']/text()").evaluate(nl.item(i), XPathConstants.NODESET);
                    if (identifiersNl.getLength() > 0) {
                        type = identifiersNl.item(0).getNodeValue();
                    }
                    if ((identifiersNl = (NodeList)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']//*[name()='common:external-id-value']/text()").evaluate(nl.item(i), XPathConstants.NODESET)).getLength() > 0) {
                        id = identifiersNl.item(0).getNodeValue();
                    }
                    if (type == null || !type.equals("doi") || id == null) continue;
                    result.setDoi(id);
                    result.setExternalUrl("https://dx.doi.org/" + id);
                }
                if (result.getExternalUrl() == null && (nl = (NodeList)xpath.compile("//*[name()='work:work'][@put-code='" + orcidwork + "']//*[name()='common:source']/*[name()='common:source-client-id']/*[name()='common:uri']/text()").evaluate(document, XPathConstants.NODESET)).getLength() > 0) {
                    result.setExternalUrl(nl.item(0).getNodeValue());
                }
                nl = (NodeList)xpath.compile("//*[name()='work:work-summary'][@put-code='" + orcidwork + "']//*[name()='work:work-summary']").evaluate(document, XPathConstants.NODESET);
                for (i = 0; i < nl.getLength(); ++i) {
                    if (worknl.item(0).isEqualNode(nl.item(i))) continue;
                    nl.item(i).getParentNode().removeChild(nl.item(i));
                }
                DOMSource domSource = new DOMSource(document);
                StringWriter writer = new StringWriter();
                StreamResult streamResult = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, streamResult);
                result.setOrcidworkid(orcidworkid);
                result.setOpenaireId(ExternalRecordParser.createOpenaireId((String)(orcidworkid + idSuffix)));
                result.setMetadataRecord(writer.toString());
                result.setRecordFormat("xml");
                result.setCollectedFrom("openaire____::orcid");
            }
        }
        catch (Exception e) {
            logger.error("Error parsing Orcid result\n" + xml, (Throwable)e);
        }
        return result;
    }

    public static Result datacite2Result(String xml, String idSuffix) {
        logger.debug("Datacite xml response:\n" + xml);
        Result result = null;
        if (xml != null) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(xml));
                Document document = dBuilder.parse(is);
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                NodeList nl = (NodeList)xpath.compile("//*[local-name()='identifier']/text()").evaluate(document, XPathConstants.NODESET);
                if (nl.getLength() > 0) {
                    result = new Result();
                    result.setResultType("dataset");
                    result.setDoi(nl.item(0).getNodeValue());
                    result.setExternalUrl("http://dx.doi.org/" + result.getDoi());
                    result.setOpenaireId(ExternalRecordParser.createOpenaireId((String)(result.getDoi() + idSuffix)));
                    nl = (NodeList)xpath.compile("//*[local-name()='title']/text()").evaluate(document, XPathConstants.NODESET);
                    if (nl.getLength() > 0) {
                        result.setTitle(nl.item(0).getNodeValue());
                    }
                    result.setMetadataRecord(xml);
                    result.setRecordFormat("xml");
                    result.setCollectedFrom("openaire____::datacite");
                    logger.debug("Datacite result" + result.toString());
                } else {
                    logger.error("Couldn't parse Datacite result\n" + xml);
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                logger.error("Error parsing Orcid result\n" + xml, (Throwable)e);
            }
        }
        return result;
    }

    public static String createOpenaireId(String id) {
        if (id == null) {
            return null;
        }
        Object openaireId = id;
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
            m.update(id.getBytes(), 0, id.length());
            openaireId = new BigInteger(1, m.digest()).toString(16);
            while (((String)openaireId).length() < 32) {
                openaireId = "0" + (String)openaireId;
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Couldn't instatiate md5 algorithm", (Throwable)e);
        }
        openaireId = "userclaim___::" + (String)openaireId;
        return openaireId;
    }
}

