/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.handler;

import eu.dnetlib.claims.service.ClaimService;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.ExceptionResponse;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LogManager.getLogger(ClaimService.class);

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<?> accessDenied(AccessDeniedException ex) {
        log.error("AccessDeniedException: " + ex.getMessage());
        return new ResponseEntity((Object)new ExceptionResponse((Exception)ex, HttpStatus.UNAUTHORIZED), (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HttpException.class})
    public ResponseEntity<?> http(HttpException ex) {
        log.error("HttpException: " + ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)new ExceptionResponse((Exception)ex, ex.getHttpStatus()), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<String> handleRuntimeException(RuntimeException ex) {
        log.error("Caught RuntimeException: {}", (Object)ex.getMessage(), (Object)ex);
        return new ResponseEntity((Object)("An error occurred: " + ex.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

