/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.model;

import eu.dnetlib.claims.model.OpenaireEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Entity
public class Result
implements OpenaireEntity {
    private static final Logger logger = LogManager.getLogger(Result.class);
    @Column(name="openaire_id")
    private String openaireId;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private String title;
    @Column(name="external_url")
    private String externalUrl;
    private String doi;
    private String orcidworkid;
    @Column(name="access_rights")
    private String accessRights;
    @Column(name="best_license")
    private String bestLicense;
    @Column(name="collected_from")
    private String collectedFrom;
    @Transient
    private String metadataRecord;
    @Column(name="record_path")
    private String recordPath;
    @Column(name="record_format")
    private String recordFormat;
    @Column(name="result_type")
    private String resultType;
    @Column(name="embargo_end_date")
    private Date embargoEndDate;

    public void setCollectedFrom(String collectedFrom) {
        if (!collectedFrom.contains("____::")) {
            collectedFrom = collectedFrom.equals("Datacite") ? "openaire____::datacite" : (collectedFrom.equals("Crossref") ? "openaire____::crossref" : (collectedFrom.equals("Orcid") ? "openaire____::orcid" : "infrastruct_::openaire"));
        }
        this.collectedFrom = collectedFrom;
    }

    public void setEmbargoEndDate(String dateString) {
        Date date;
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-").optionalStart().appendPattern("MM").optionalEnd().optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 1).optionalEnd().appendLiteral('-').optionalStart().appendPattern("dd").optionalEnd().optionalStart().appendValue(ChronoField.DAY_OF_MONTH, 1).optionalEnd().toFormatter();
        LocalDate localDate = LocalDate.parse(dateString, formatter);
        this.embargoEndDate = date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public Boolean isExternalRecord() {
        return this.getCollectedFrom() != null && this.getCollectedFrom().equals("infrastruct_::openaire");
    }

    public void updateOpenAIREIdPrefix() {
        this.setOpenaireId("userclaim___::" + this.getOpenaireId().split("::")[1]);
    }

    public static String createOpenaireId(String id, String suffix) {
        if (id == null) {
            return null;
        }
        Object openaireId = id + suffix;
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
            m.update(id.getBytes(), 0, id.length());
            openaireId = new BigInteger(1, m.digest()).toString(16);
            while (((String)openaireId).length() < 32) {
                openaireId = "0" + (String)openaireId;
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Couldn't instatiate md5 algorithm", (Throwable)e);
        }
        openaireId = "userclaim___::" + (String)openaireId;
        return openaireId;
    }

    public String getOpenaireId() {
        return this.openaireId;
    }

    public Integer getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public String getDoi() {
        return this.doi;
    }

    public String getOrcidworkid() {
        return this.orcidworkid;
    }

    public String getAccessRights() {
        return this.accessRights;
    }

    public String getBestLicense() {
        return this.bestLicense;
    }

    public String getCollectedFrom() {
        return this.collectedFrom;
    }

    public String getMetadataRecord() {
        return this.metadataRecord;
    }

    public String getRecordPath() {
        return this.recordPath;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public String getResultType() {
        return this.resultType;
    }

    public Date getEmbargoEndDate() {
        return this.embargoEndDate;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public void setOrcidworkid(String orcidworkid) {
        this.orcidworkid = orcidworkid;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    public void setBestLicense(String bestLicense) {
        this.bestLicense = bestLicense;
    }

    public void setMetadataRecord(String metadataRecord) {
        this.metadataRecord = metadataRecord;
    }

    public void setRecordPath(String recordPath) {
        this.recordPath = recordPath;
    }

    public void setRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public String toString() {
        return "Result(openaireId=" + this.getOpenaireId() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", externalUrl=" + this.getExternalUrl() + ", doi=" + this.getDoi() + ", orcidworkid=" + this.getOrcidworkid() + ", accessRights=" + this.getAccessRights() + ", bestLicense=" + this.getBestLicense() + ", collectedFrom=" + this.getCollectedFrom() + ", metadataRecord=" + this.getMetadataRecord() + ", recordPath=" + this.getRecordPath() + ", recordFormat=" + this.getRecordFormat() + ", resultType=" + this.getResultType() + ", embargoEndDate=" + String.valueOf(this.getEmbargoEndDate()) + ")";
    }
}

