/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.Claim;
import eu.dnetlib.claims.model.ClaimDTO;
import eu.dnetlib.claims.model.ClaimToSave;
import eu.dnetlib.claims.model.Context;
import eu.dnetlib.claims.model.HasSourceContext;
import eu.dnetlib.claims.model.HasSourceOrganization;
import eu.dnetlib.claims.model.HasSourceProject;
import eu.dnetlib.claims.model.HasSourceResult;
import eu.dnetlib.claims.model.HasTargetResult;
import eu.dnetlib.claims.model.OpenaireEntity;
import eu.dnetlib.claims.model.Organization;
import eu.dnetlib.claims.model.PageDTO;
import eu.dnetlib.claims.model.Project;
import eu.dnetlib.claims.model.Result;
import eu.dnetlib.claims.repository.ClaimRepository;
import eu.dnetlib.claims.repository.ContextRepository;
import eu.dnetlib.claims.repository.HasSourceContextRepository;
import eu.dnetlib.claims.repository.HasSourceOrganizationRepository;
import eu.dnetlib.claims.repository.HasSourceProjectRepository;
import eu.dnetlib.claims.repository.HasSourceResultRepository;
import eu.dnetlib.claims.repository.HasTargetResultRepository;
import eu.dnetlib.claims.repository.OrganizationRepository;
import eu.dnetlib.claims.repository.ProjectRepository;
import eu.dnetlib.claims.repository.ResultRepository;
import eu.dnetlib.claims.service.FetchContextService;
import eu.dnetlib.claims.service.FetchFromCrossrefService;
import eu.dnetlib.claims.service.FetchFromDataciteService;
import eu.dnetlib.claims.service.FetchFromGraphService;
import eu.dnetlib.claims.service.FetchFromOrcidService;
import eu.dnetlib.claims.service.HandleRecordFileService;
import eu.dnetlib.claims.utils.ClaimUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ClaimService {
    @Autowired
    private ClaimRepository claimRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ContextRepository contextRepository;
    @Autowired
    private ResultRepository resultRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private HasTargetResultRepository hasTargetResultRepository;
    @Autowired
    private HasSourceResultRepository hasSourceResultRepository;
    @Autowired
    private HasSourceProjectRepository hasSourceProjectRepository;
    @Autowired
    private HasSourceOrganizationRepository hasSourceOrganizationRepository;
    @Autowired
    private HasSourceContextRepository hasSourceContextRepository;
    @Autowired
    private FetchFromGraphService fetchFromGraphService;
    @Autowired
    private FetchContextService fetchContextService;
    @Autowired
    private FetchFromCrossrefService fetchFromCrossrefService;
    @Autowired
    private FetchFromDataciteService fetchFromDataciteService;
    @Autowired
    private FetchFromOrcidService fetchFromOrcidService;
    @Autowired
    private HandleRecordFileService handleRecordFileService;
    @Autowired
    private AuthorizationService authorizationService;
    private static final Logger logger = LogManager.getLogger(ClaimService.class);

    public PageDTO<ClaimDTO> getClaims(Pageable pageable, Boolean mine, String mail, List<String> types, String orderBy, Boolean desc, String keyword) {
        Page claimsPage = this.claimRepository.findByCriteriaJoin(pageable, types.size() == 0 ? this.getAllTypes() : types, types.size() == 0 ? this.getAllTypes() : types, mine != false ? mail : "", null, null, null, null, orderBy, desc, keyword.toLowerCase());
        List claimDTOs = claimsPage.getContent().stream().map(arg_0 -> this.mapToDTO(arg_0)).collect(Collectors.toList());
        return new PageDTO(claimDTOs, claimsPage.getNumber(), claimsPage.getSize(), claimsPage.getTotalElements(), claimsPage.getTotalPages());
    }

    public PageDTO<ClaimDTO> getClaimsFromTo(Pageable pageable, Boolean mine, String mail, List<String> types, String orderBy, Boolean desc, String keyword, Date from, Date to, String sourceType, String sourceId) {
        Page claimsPage = this.claimRepository.findByCriteriaJoin(pageable, types.size() == 0 ? this.getAllTypes() : types, types.size() == 0 ? this.getAllTypes() : types, mine != false ? mail : "", sourceType, sourceId, from, to, orderBy, desc, keyword.toLowerCase());
        List claimDTOs = claimsPage.getContent().stream().map(arg_0 -> this.mapToDTO(arg_0)).collect(Collectors.toList());
        return new PageDTO(claimDTOs, claimsPage.getNumber(), claimsPage.getSize(), claimsPage.getTotalElements(), claimsPage.getTotalPages());
    }

    public PageDTO<ClaimDTO> getClaimsBySource(Pageable pageable, Boolean mine, String mail, List<String> types, String orderBy, Boolean desc, String keyword, String sourceType, String sourceId) {
        Page claimsPage = this.claimRepository.findByCriteriaJoin(pageable, types.size() == 0 ? this.getAllTypes() : types, types.size() == 0 ? this.getAllTypes() : types, mine != false ? mail : "", sourceType, sourceId, null, null, orderBy, desc, keyword.toLowerCase());
        List claimDTOs = claimsPage.getContent().stream().map(arg_0 -> this.mapToDTO(arg_0)).collect(Collectors.toList());
        return new PageDTO(claimDTOs, claimsPage.getNumber(), claimsPage.getSize(), claimsPage.getTotalElements(), claimsPage.getTotalPages());
    }

    public Claim getClaimById(Integer id) {
        return this.claimRepository.findById((Object)id).orElse(null);
    }

    public void deleteClaim(Claim claim) {
        Integer countSourceUsages;
        this.hasTargetResultRepository.deleteByClaimId(claim.getId());
        this.deleteSourceRelation(claim.getSourceType(), claim.getId());
        this.claimRepository.deleteById((Object)claim.getId());
        Integer countTargetUsages = this.claimRepository.countClaimByTargetId(claim.getTargetId()) + this.claimRepository.countClaimBySourceId(claim.getTargetId());
        if (countTargetUsages == 0) {
            this.deleteResult(claim.getTargetId());
        }
        if ((countSourceUsages = Integer.valueOf(this.claimRepository.countClaimByTargetId(claim.getSourceId()) + this.claimRepository.countClaimBySourceId(claim.getSourceId()))) == 0) {
            this.deleteSource(claim.getSourceType(), claim.getSourceId());
        }
    }

    private void deleteSourceRelation(String type, Integer claimId) {
        if (type.equals("project")) {
            this.hasSourceProjectRepository.deleteByClaimId(claimId);
        } else if (type.equals("organization")) {
            this.hasSourceOrganizationRepository.deleteByClaimId(claimId);
        } else if (type.equals("context")) {
            this.hasSourceContextRepository.deleteByClaimId(claimId);
        } else {
            this.hasSourceResultRepository.deleteByClaimId(claimId);
        }
    }

    private void deleteSource(String type, String openaireId) {
        if (type.equals("project")) {
            this.projectRepository.deleteById((Object)openaireId);
        } else if (type.equals("organization")) {
            this.organizationRepository.deleteByOpenaireId(openaireId);
        } else if (type.equals("context")) {
            this.contextRepository.deleteByOpenaireId(openaireId);
        } else {
            this.deleteResult(openaireId);
        }
    }

    private void deleteResult(String openaireId) {
        Result result = this.resultRepository.findByOpenaireId(openaireId);
        this.resultRepository.deleteByOpenaireId(openaireId);
        this.handleRecordFileService.deleteRecordFile(result.getResultType(), result.getCollectedFrom(), result.getOpenaireId());
    }

    private ClaimDTO mapToDTO(Object[] claims) {
        Integer source;
        Integer index = 0;
        ClaimDTO dto = new ClaimDTO();
        dto.setId((Integer)claims[index]);
        Integer n = index;
        index = index + 1;
        dto.setUserMail((String)claims[index]);
        n = index;
        index = index + 1;
        dto.setDate((Date)claims[index]);
        n = index;
        index = index + 1;
        dto.setSourceType((String)claims[index]);
        n = index;
        index = index + 1;
        dto.setTargetType((String)claims[index]);
        n = index;
        index = index + 1;
        dto.setSourceId((String)claims[index]);
        n = index;
        index = index + 1;
        dto.setTargetId((String)claims[index]);
        n = index;
        index = index + 1;
        dto.setSemantics((String)claims[index]);
        n = index;
        index = index + 1;
        Result target = new Result();
        target.setOpenaireId(dto.getTargetId());
        target.setResultType(dto.getTargetType());
        target.setTitle((String)claims[index]);
        Integer n2 = index;
        index = index + 1;
        if (claims[index] != null) {
            target.setCollectedFrom((String)claims[index]);
        }
        dto.setTarget((OpenaireEntity)target);
        n2 = index;
        index = index + 1;
        if ((String)claims[index] != null) {
            source = new Result();
            source.setOpenaireId(dto.getSourceId());
            source.setResultType(dto.getSourceType());
            source.setTitle((String)claims[index]);
            dto.setSource((OpenaireEntity)source);
        }
        source = index;
        index = index + 1;
        if ((String)claims[index] != null) {
            source = new Project();
            source.setOpenaireId(dto.getSourceId());
            source.setName((String)claims[index]);
            Integer n3 = index;
            index = index + 1;
            source.setAcronym((String)claims[index]);
            n3 = index;
            index = index + 1;
            source.setFunderName((String)claims[index]);
            n3 = index;
            index = index + 1;
            source.setFunderShortName((String)claims[index]);
            n3 = index;
            index = index + 1;
            source.setFunderId((String)claims[index]);
            n3 = index;
            index = index + 1;
            dto.setSource((OpenaireEntity)source);
        } else {
            index = index + 5;
        }
        if ((String)claims[index] != null) {
            source = new Context();
            source.setOpenaireId(dto.getSourceId());
            source.setTitle((String)claims[index]);
            dto.setSource((OpenaireEntity)source);
        }
        source = index;
        index = index + 1;
        if ((String)claims[index] != null) {
            source = new Organization();
            source.setOpenaireId(dto.getSourceId());
            source.setShortName((String)claims[index]);
            source.setName((String)claims[index]);
            dto.setSource((OpenaireEntity)source);
        }
        return dto;
    }

    private List<String> getResultTypes() {
        return new ArrayList<String>(Arrays.asList("publication", "dataset", "software", "other"));
    }

    private List<String> getAllTypes() {
        ArrayList<String> types = new ArrayList<String>(Arrays.asList("context", "organization", "project"));
        types.addAll(this.getResultTypes());
        return types;
    }

    public Integer buildAndInsertClaim(ClaimToSave claimToSave, String user) {
        Claim claim = new Claim();
        claim.setDate(new Date());
        claim.setClaimedInDashboard(claimToSave.getClaimedInDashboard());
        claim.setSourceId(claimToSave.getSourceId());
        claim.setSourceType(claimToSave.getSourceType());
        claim.setTargetId(claimToSave.getTargetId());
        claim.setTargetType(claimToSave.getTargetType());
        claim.setSemantics(ClaimUtils.getSemantics((String)claim.getSourceType()));
        claim.setUserMail(user);
        Result target = null;
        try {
            if (claimToSave.getTargetCollectedFrom().equals("openaire")) {
                target = this.fetchFromGraphService.fetchResultById(claimToSave.getTargetId(), claim.getTargetType());
                target.updateOpenAIREIdPrefix();
            } else if (claimToSave.getTargetCollectedFrom().equals("crossref")) {
                target = this.fetchFromCrossrefService.fetchResultfromCrossref(claimToSave.getTargetId(), claimToSave.getIdSuffix());
            } else if (claimToSave.getTargetCollectedFrom().equals("datacite")) {
                target = this.fetchFromDataciteService.fetchResultfromDatacite(claimToSave.getTargetId(), claimToSave.getIdSuffix());
            } else if (claimToSave.getTargetCollectedFrom().equals("orcid")) {
                target = this.fetchFromOrcidService.fetchResultfromOrcid(claimToSave.getTargetId(), claimToSave.getIdSuffix());
            }
            if (!target.isExternalRecord().booleanValue()) {
                target.setAccessRights(claimToSave.getTargetAccessRights());
                if (claimToSave.getTargetAccessRights().equals("EMBARGO") && claimToSave.getTargetEmbargoEndDate() != null && !claimToSave.getTargetEmbargoEndDate().isEmpty()) {
                    target.setEmbargoEndDate(claimToSave.getTargetEmbargoEndDate());
                }
                target.setResultType(claimToSave.getTargetType());
            }
            claim.setTargetId(target.getOpenaireId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (target == null) {
            return null;
        }
        this.saveResult(target);
        Project source = null;
        try {
            if (claim.getSourceType().equals("project")) {
                source = this.fetchFromGraphService.fetchProjectById(claim.getSourceId());
            } else if (claim.getSourceType().equals("context")) {
                source = this.fetchContextService.fetchContextById(claim.getSourceId());
            } else if (claim.getSourceType().equals("organization")) {
                source = this.fetchFromGraphService.fetchOrganizationById(claim.getSourceId());
            } else {
                if (claimToSave.getSourceCollectedFrom().equals("openaire")) {
                    source = this.fetchFromGraphService.fetchResultById(claim.getSourceId(), claim.getSourceType());
                    ((Result)source).updateOpenAIREIdPrefix();
                } else if (claimToSave.getTargetCollectedFrom().equals("crossref")) {
                    source = this.fetchFromCrossrefService.fetchResultfromCrossref(claimToSave.getSourceId(), claimToSave.getIdSuffix());
                } else if (claimToSave.getTargetCollectedFrom().equals("datacite")) {
                    source = this.fetchFromDataciteService.fetchResultfromDatacite(claimToSave.getSourceId(), claimToSave.getIdSuffix());
                } else if (claimToSave.getTargetCollectedFrom().equals("orcid")) {
                    source = this.fetchFromOrcidService.fetchResultfromOrcid(claimToSave.getSourceId(), claimToSave.getIdSuffix());
                }
                if (source == null) {
                    return null;
                }
                claim.setSourceId(((Result)source).getOpenaireId());
                if (!claimToSave.getSourceCollectedFrom().equals("openaire")) {
                    ((Result)source).setAccessRights(claimToSave.getSourceAccessRights());
                    if (claimToSave.getSourceAccessRights().equals("EMBARGO") && claimToSave.getSourceEmbargoEndDate() != null && !claimToSave.getSourceEmbargoEndDate().isEmpty()) {
                        ((Result)source).setEmbargoEndDate(claimToSave.getSourceEmbargoEndDate());
                    }
                    ((Result)source).setResultType(claimToSave.getSourceType());
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (source == null) {
            return null;
        }
        this.saveSource((OpenaireEntity)source, claim.getSourceType());
        Claim saved = (Claim)this.claimRepository.save((Object)claim);
        HasTargetResult hasTargetResult = new HasTargetResult(claim.getTargetId(), saved.getId());
        this.hasTargetResultRepository.save((Object)hasTargetResult);
        this.saveSourceRelation(claim.getSourceType(), claim.getId(), claim.getSourceId());
        return saved.getId();
    }

    public void saveSource(OpenaireEntity source, String type) {
        if (type.equals("project")) {
            this.saveProject((Project)source);
        } else if (type.equals("context")) {
            this.saveContext((Context)source);
        } else if (type.equals("organization")) {
            this.saveOrganization((Organization)source);
        } else {
            this.saveResult((Result)source);
        }
    }

    public void saveSourceRelation(String type, Integer claimId, String openaireId) {
        if (type.equals("project")) {
            this.hasSourceProjectRepository.save((Object)new HasSourceProject(openaireId, claimId));
        } else if (type.equals("organization")) {
            this.hasSourceOrganizationRepository.save((Object)new HasSourceOrganization(openaireId, claimId));
        } else if (type.equals("context")) {
            this.hasSourceContextRepository.save((Object)new HasSourceContext(openaireId, claimId));
        } else {
            this.hasSourceResultRepository.save((Object)new HasSourceResult(openaireId, claimId));
        }
    }

    public void saveResult(Result result) {
        if (this.resultRepository.findByOpenaireId(result.getOpenaireId()) == null) {
            result.setRecordPath(this.handleRecordFileService.exportMetadataFileForResult(result));
            result.setMetadataRecord("");
            this.resultRepository.save((Object)result);
        }
    }

    private void saveProject(Project project) {
        if (!this.projectRepository.findById((Object)project.getOpenaireId()).isPresent()) {
            this.projectRepository.save((Object)project);
        }
    }

    private void saveContext(Context context) {
        if (this.contextRepository.findByOpenaireId(context.getOpenaireId()) == null) {
            this.contextRepository.save((Object)context);
        }
    }

    private void saveOrganization(Organization organization) {
        if (this.organizationRepository.findByOpenaireId(organization.getOpenaireId()) == null) {
            this.organizationRepository.save((Object)organization);
        }
    }

    private String getDashboardPID(Claim claim) {
        if (claim.getClaimedInDashboard() != null && claim.getClaimedInDashboard().split("_").length == 3) {
            return claim.getClaimedInDashboard().split("_")[2];
        }
        return null;
    }

    private String getDashboardType(Claim claim) {
        if (claim.getClaimedInDashboard() != null && claim.getClaimedInDashboard().split("_").length > 2) {
            String type = claim.getClaimedInDashboard().split("_")[1];
            if (type.equals("connect")) {
                return "COMMUNITY";
            }
            if (type.equals("monitor")) {
                return "INSTITUTION";
            }
        }
        return null;
    }

    public Boolean canUserDeleteClaim(Claim claim) {
        if (claim.getUserMail().equals(this.authorizationService.getEmail()) || this.authorizationService.isCurator("CLAIM") || this.authorizationService.isPortalAdmin()) {
            return true;
        }
        if ((claim.getSourceType().equals("context") || "COMMUNITY".equals(this.getDashboardType(claim))) && (this.authorizationService.isCurator("COMMUNITY") || this.authorizationService.isCurator("RI"))) {
            return true;
        }
        if (claim.getSourceType().equals("context") && this.authorizationService.isManager("COMMUNITY", claim.getSourceId().split("::")[0])) {
            return true;
        }
        if ("COMMUNITY".equals(this.getDashboardType(claim)) && this.authorizationService.isManager("COMMUNITY", this.getDashboardPID(claim))) {
            return true;
        }
        if ((claim.getSourceType().equals("organization") || "INSTITUTION".equals(this.getDashboardType(claim))) && (this.authorizationService.isCurator("INSTITUTION") || this.authorizationService.isManager("INSTITUTION", this.getDashboardPID(claim)))) {
            return true;
        }
        return false;
    }
}

