/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.configuration.GlobalVars;
import eu.dnetlib.claims.configuration.PostgresConfig;
import eu.dnetlib.claims.service.EmailService;
import eu.dnetlib.claims.service.ManagerUtilsService;
import eu.dnetlib.uoaauthorizationlibrary.AuthorizationConfiguration;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DeployService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    GlobalVars globalVars;
    @Autowired
    PostgresConfig postgresConfig;
    public static Instant dateInstant = Instant.now();
    @Autowired
    AuthorizationConfiguration authorizationConfiguration;
    @Autowired
    ManagerUtilsService managerUtilsService;
    @Autowired
    EmailService emailService;
    @Value(value="${services.claims.orcidUrlPrefix}")
    private String orcidAPIURL;
    @Value(value="${services.claims.orcidUrlSuffix}")
    private String orcidURLSuffix;
    @Value(value="${services.claims.dataciteUrl}")
    private String dataciteUrl;
    @Value(value="${services.claims.crossrefUrl}")
    private String crossrefUrl;
    @Value(value="${services.claims.searchAPIUrl}")
    private String searchAPIUrl;
    @Value(value="${services.claims.directClaimAPIUrl}")
    private String directClaimAPIUrl;
    @Value(value="${services.claims.contextsAPIUrl}")
    private String contextsAPIUrl;
    @Value(value="${services.claims.registryAPIForManagerEmails}")
    private String registryAPIForManagerEmails;
    @Value(value="${services.claims.mail.host}")
    private String mailHost;
    @Value(value="${services.claims.mail.port}")
    private String mailPort;
    @Value(value="${services.claims.mail.auth}")
    private String mailAuth;
    @Value(value="${services.claims.mail.from}")
    private String mailFrom;
    @Value(value="${services.claims.mail.username}")
    private String mailUsername;
    @Value(value="${services.claims.mail.password}")
    private String mailPassword;
    @Value(value="${services.claims.mail.sslProtocols}")
    private String sslProtocols;
    @Value(value="${services.claims.mail.specialRecipients}")
    private String specialRecipients;
    @Value(value="${services.claims.mail.contactMail}")
    private String contactMail;
    @Value(value="${services.claims.mail.openaireCommunityClaimsPage}")
    private String openaireCommunityClaimsPage;
    @Value(value="${services.claims.mail.manageCommunityUserNotificationsPage}")
    private String manageCommunityUserNotificationsPage;
    @Value(value="${services.claims.mail.notifyCommunityManagers}")
    private String notifyCommunityManagers;
    @Value(value="${services.claims.db.url}")
    private String dbUrl;
    @Value(value="${services.claims.db.username}")
    private String dbUsername;
    @Value(value="${services.claims.db.password}")
    private String dbPwd;
    @Value(value="${services.claims.results.pathToSaveRecord}")
    private String pathToSaveRecord;

    @Autowired
    public DeployService() {
    }

    @PostConstruct
    public void checkProperties() {
        this.log.debug("Checking properties....");
        if (this.dbUrl == null || this.dbUrl.isEmpty()) {
            throw new RuntimeException("services.claims.db.url is missing!");
        }
        if (this.dbPwd == null || this.dbPwd.isEmpty()) {
            throw new RuntimeException("services.claims.db.password is missing!");
        }
        if (this.dbUrl == null || this.dbUrl.isEmpty()) {
            throw new RuntimeException("services.claims.db.username is missing!");
        }
        if (this.directClaimAPIUrl == null || this.directClaimAPIUrl.isEmpty()) {
            throw new RuntimeException("services.claims.directClaimAPIUrl is missing!");
        }
        if (this.searchAPIUrl == null || this.searchAPIUrl.isEmpty()) {
            throw new RuntimeException("services.claims.searchAPIUrl is missing!");
        }
        if (this.searchAPIUrl == null || this.searchAPIUrl.isEmpty()) {
            throw new RuntimeException("services.claims.searchAPIUrl is missing!");
        }
        if (this.pathToSaveRecord == null || this.pathToSaveRecord.isEmpty()) {
            throw new RuntimeException("services.claims.results.pathToSaveRecord is missing!");
        }
        if (this.contextsAPIUrl == null || this.contextsAPIUrl.isEmpty()) {
            throw new RuntimeException("services.claims.contextsAPIUrl is missing!");
        }
        if (this.registryAPIForManagerEmails == null || this.registryAPIForManagerEmails.isEmpty()) {
            throw new RuntimeException("services.claims.registryAPIForManagerEmails is missing!");
        }
        if (this.mailHost == null || this.mailHost.isEmpty()) {
            throw new RuntimeException("services.claims.mail.host is missing!");
        }
        if (this.mailPort == null || this.mailPort.isEmpty()) {
            throw new RuntimeException("services.claims.mail.port is missing!");
        }
        if (this.mailAuth == null || this.mailAuth.isEmpty()) {
            throw new RuntimeException("services.claims.mail.auth is missing!");
        }
        if (this.mailFrom == null || this.mailFrom.isEmpty()) {
            throw new RuntimeException("services.claims.mail.from is missing!");
        }
        if (this.mailUsername == null || this.mailUsername.isEmpty()) {
            throw new RuntimeException("services.claims.mail.username is missing!");
        }
        if (this.mailPassword == null || this.mailPassword.isEmpty()) {
            throw new RuntimeException("services.claims.mail.password is missing!");
        }
        if (this.contactMail == null || this.contactMail.isEmpty()) {
            throw new RuntimeException("services.claims.mail.contactMail is missing!");
        }
        if (this.openaireCommunityClaimsPage == null || this.openaireCommunityClaimsPage.isEmpty()) {
            throw new RuntimeException("services.claims.mail.openaireCommunityClaimsPage is missing!");
        }
        if (this.manageCommunityUserNotificationsPage == null || this.manageCommunityUserNotificationsPage.isEmpty()) {
            throw new RuntimeException("services.claims.mail.manageCommunityUserNotificationsPage is missing!");
        }
        if (this.notifyCommunityManagers == null || this.notifyCommunityManagers.isEmpty()) {
            throw new RuntimeException("services.claims.mail.notifyCommunityManagers is missing!");
        }
        this.log.debug("Properties ok!");
    }

    public Map<String, String> getProperties() {
        Map response = this.authorizationConfiguration.getProperties();
        response.put("DB Url", this.dbUrl);
        response.put("DB Username", this.dbUsername == null ? null : "[unexposed value]");
        response.put("DB Pwd", this.dbPwd == null ? null : "[unexposed value]");
        response.put("Apis -  search", this.searchAPIUrl);
        response.put("Apis -  orcid", this.orcidAPIURL);
        response.put("Apis -  orcid suffix", this.orcidURLSuffix);
        response.put("Apis -  crossref", this.crossrefUrl);
        response.put("Apis -  datacite", this.dataciteUrl);
        response.put("Apis -  direct claim", this.directClaimAPIUrl);
        response.put("Path for records", this.pathToSaveRecord);
        response.put("Date of deploy", GlobalVars.date.toString());
        response.put("contextsAPIUrl", this.contextsAPIUrl);
        response.put("registryAPIForManagerEmails", this.registryAPIForManagerEmails);
        response.put("mailHost", this.mailHost);
        response.put("mailPort", this.mailPort);
        response.put("mailAuth", this.mailAuth);
        response.put("mailFrom", this.mailFrom);
        response.put("mailUsername", this.mailUsername);
        response.put("mailPassword", this.mailPassword);
        response.put("sslProtocols", this.sslProtocols);
        response.put("specialRecipients", this.specialRecipients);
        response.put("contactMail", this.contactMail);
        response.put("openaireCommunityClaimsPage", this.openaireCommunityClaimsPage);
        response.put("manageCommunityUserNotificationsPage", this.manageCommunityUserNotificationsPage);
        response.put("notifyCommunityManagers", this.notifyCommunityManagers);
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

