/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.Result;
import eu.dnetlib.claims.parser.ExternalRecordParser;
import eu.dnetlib.claims.service.BasicFetchService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FetchFromCrossrefService
extends BasicFetchService {
    @Value(value="${services.claims.crossrefUrl}")
    private String APIURL;

    private String fetchCrossrefRecord(String doi) {
        return this.getCrossrefJsonRecord(doi);
    }

    public Result fetchResultfromCrossref(String doi, String idSuffix) {
        return ExternalRecordParser.crossref2Result((String)this.fetchCrossrefRecord(doi), (String)idSuffix);
    }

    private String getCrossrefJsonRecord(String doi) {
        String url = this.APIURL + doi;
        URL obj = null;
        String responseStr = null;
        try {
            String inputLine;
            obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            in.close();
            responseStr = response.toString();
            if (responseStr == null || !responseStr.contains("\"status\":\"ok\"") || !responseStr.contains("\"DOI\":\"")) {
                responseStr = null;
            }
        }
        catch (Exception e) {
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("dois_malformed_urls.txt", true)));
                Date date = new Date();
                out.println(String.valueOf(new Timestamp(date.getTime())) + "Doi:" + doi + " Url:" + url);
                out.close();
            }
            catch (IOException e1) {
                this.logger.error("Couldn't write to file dois_malformed_urls.txt", (Throwable)e);
            }
        }
        return responseStr;
    }

    public boolean isDoiValid(String doi) throws IOException {
        boolean found = false;
        String responseStr = this.getCrossrefJsonRecord(doi);
        if (responseStr != null) {
            found = true;
        }
        return found;
    }

    public String getAPIURL() {
        return this.APIURL;
    }

    public void setAPIURL(String APIURL) {
        this.APIURL = APIURL;
    }
}

