/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utility.cleaner.inspector;

import com.google.common.collect.Lists;
import eu.dnetlib.data.utility.cleaner.CleaningRule;
import eu.dnetlib.data.utility.cleaner.CleaningRuleFactory;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerException;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CleanerInspector
extends AbstractInspectorController {
    @Resource
    private CleaningRuleFactory cleaningRuleFactory;

    @RequestMapping(value={"/inspector/cleaner.do"})
    public void cleaner(Model model, @RequestParam(value="rule", required=false) String ruleId, @RequestParam(value="dirtyText", required=false) String dirtyText) throws CleanerException {
        ArrayList rules = Lists.newArrayList(this.cleaningRuleFactory.getRuleIds());
        model.addAttribute("rules", this.selectOptions(rules, ruleId));
        if (ruleId != null && dirtyText != null) {
            CleaningRule rule = this.cleaningRuleFactory.obtainCleaningRule(ruleId);
            model.addAttribute("dirtyText", (Object)dirtyText);
            model.addAttribute("cleanedText", (Object)rule.evaluate(dirtyText));
        }
    }

    private List<SelectOption> selectOptions(List<String> input, final String current) {
        UnaryFunction<SelectOption, String> mapper = new UnaryFunction<SelectOption, String>(){

            public SelectOption evaluate(String value) {
                return new SelectOption(value, value.equals(current));
            }
        };
        return Lists.newArrayList((Iterable)new MappedCollection(input, (UnaryFunction)mapper));
    }

    public static class SelectOption {
        private String value;
        private boolean selected;

        public SelectOption(String value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

