/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.action;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.action.AbstractMDStoreAction;
import eu.dnetlib.data.mdstore.modular.action.DoneCallback;
import eu.dnetlib.data.mdstore.modular.action.MDStorePlugin;
import eu.dnetlib.data.mdstore.modular.action.MDStorePluginEnumerator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PluginAction
extends AbstractMDStoreAction {
    private static final Log log = LogFactory.getLog(PluginAction.class);
    @Autowired
    private MDStorePluginEnumerator pluginEnumerator;

    @Override
    protected void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws MDStoreServiceException {
        String name = (String)job.getParameters().get("plugin.name");
        Map<String, MDStorePlugin> plugins = this.pluginEnumerator.getAll();
        if (plugins == null || plugins.isEmpty() || !plugins.containsKey(name)) {
            throw new MDStoreServiceException("Unable to find plugin: " + name);
        }
        log.info((Object)("running MDStore plugin: " + name));
        plugins.get(name).run(this.getDao(), job.getParameters(), new DoneCallback(){

            @Override
            public void call(Map<String, String> params) {
                job.getParameters().putAll(params);
                handler.done(job);
            }
        });
    }
}

