/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDFormatDescription;
import eu.dnetlib.data.mdstore.modular.RecordParser;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoBulkWritesManager;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoResultSetListener;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Required;

public class MongoMDStore
implements MDStore {
    private static final int BULK_SIZE = 500;
    private static final Log log = LogFactory.getLog(MongoMDStore.class);
    private final boolean discardRecords;
    private String id;
    private final MongoDatabase mongoDatabase;
    private MongoCollection<DBObject> collection;
    private MongoCollection<DBObject> discardedCollection;
    private List<MDFormatDescription> mdformats;
    private RecordParser recordParser;
    private static List<String> indices = Lists.newArrayList((Object[])new String[]{"id", "timestamp", "originalId"});
    private final IndexOptions options = new IndexOptions().background(true);

    public MongoMDStore(String id, MongoCollection<DBObject> collection, RecordParser recordParser, boolean discardRecords, MongoDatabase mongoDatabase) {
        this.id = id;
        this.mongoDatabase = mongoDatabase;
        this.collection = collection;
        this.discardedCollection = this.mongoDatabase.getCollection("discarded-" + StringUtils.substringBefore((String)id, (String)"_"), DBObject.class);
        this.recordParser = recordParser;
        this.discardRecords = discardRecords;
    }

    public int feed(Iterable<String> records, boolean incremental, List<MDFormatDescription> mdformats) {
        this.mdformats = mdformats;
        return this.feed(records, incremental);
    }

    public int feed(Iterable<String> records, boolean incremental) {
        this.ensureIndices();
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(100);
        Object sentinel = new Object();
        int countStored = 0;
        Callable<Integer> writer = () -> {
            MongoBulkWritesManager bulkWritesManager = new MongoBulkWritesManager(this.collection, this.discardedCollection, this.mdformats, 500, this.recordParser, this.discardRecords);
            int count = 0;
            try {
                while (true) {
                    Object record;
                    if ((record = queue.poll(1L, TimeUnit.HOURS)) == null) {
                        log.fatal((Object)"retrieved a null object, probably the feeding is failed");
                        throw new IllegalStateException("retrieved a null object, probably the feeding wf is failed");
                    }
                    if (record.equals(sentinel)) {
                        bulkWritesManager.flushBulks();
                        break;
                    }
                    ++count;
                    bulkWritesManager.insert((String)record);
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"got exception in background thread", (Throwable)e);
                throw new IllegalStateException(e);
            }
            log.debug((Object)String.format("extracted %s records from feeder queue", count));
            return count;
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Integer> storedCountInt = executorService.submit(writer);
        try {
            log.info((Object)("feeding mdstore " + this.id));
            if (records != null) {
                for (String record : records) {
                    if (record == null) continue;
                    queue.put(record);
                }
            }
            queue.put(sentinel);
            countStored = storedCountInt.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Object)("Error on feeding mdstore with id:" + this.id), (Throwable)e);
            throw new IllegalStateException(e);
        }
        log.info((Object)("finished feeding mdstore " + this.id));
        return countStored;
    }

    public void ensureIndices() {
        for (String key : indices) {
            this.collection.createIndex((Bson)new BasicDBObject(key, (Object)1), this.options);
        }
        if (this.mdformats != null) {
            for (MDFormatDescription description : this.mdformats) {
                this.collection.createIndex((Bson)new BasicDBObject(description.getName(), (Object)1), this.options);
            }
        }
    }

    public boolean isIndexed() {
        ListIndexesIterable found = this.collection.listIndexes(DBObject.class);
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)found, dbo -> {
            Set keyset = ((DBObject)dbo.get("key")).toMap().keySet();
            return (String)Iterables.getFirst(keyset, (Object)"");
        })).containsAll(indices);
    }

    public void replace(String grep, String replace) {
        Pattern regex = Pattern.compile(grep, 8);
        BasicDBObject query = (BasicDBObject)QueryBuilder.start((String)"body").regex(regex).get();
        FindIterable matches = this.collection.find((Bson)query, DBObject.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("FOUND: " + Lists.newArrayList((Iterable)matches).size()));
        }
        for (DBObject match : matches) {
            BasicDBObject o = new BasicDBObject(match.toMap());
            o.put("body", (Object)regex.matcher((String)match.get("body")).replaceAll(replace));
            this.collection.findOneAndReplace((Bson)new BasicDBObject("_id", o.get("_id")), (Object)o);
        }
    }

    public ResultSetListener deliver(String from, String until, String recordFilter) throws MDStoreServiceException {
        return this.deliver(from, until, recordFilter, new SerializeMongoRecord());
    }

    public ResultSetListener deliverIds(String from, String until, String recordFilter) throws MDStoreServiceException {
        return this.deliver(from, until, recordFilter, new SerializeMongoRecordId());
    }

    public ResultSetListener deliver(String from, String until, String recordFilter, Function<DBObject, String> serializer) throws MDStoreServiceException {
        Pattern filter = recordFilter != null && recordFilter.length() > 0 ? Pattern.compile(recordFilter, 8) : null;
        return new MongoResultSetListener(this.collection, this.parseLong(from), this.parseLong(until), filter, serializer);
    }

    private Long parseLong(String s) throws MDStoreServiceException {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new MDStoreServiceException("Invalid date, expected java.lang.Long, or null", (Throwable)e);
        }
    }

    public Iterable<String> iterate() {
        return () -> Iterators.transform((Iterator)this.collection.find().iterator(), arg -> (String)arg.get("body"));
    }

    public void deleteRecord(String recordId) {
        this.collection.deleteOne((Bson)new BasicDBObject("id", (Object)recordId));
    }

    public String getRecord(String recordId) throws DocumentNotFoundException {
        DBObject obj = (DBObject)this.collection.find((Bson)new BasicDBObject("id", (Object)recordId)).first();
        if (obj == null || !obj.containsField("body")) {
            throw new DocumentNotFoundException(String.format("The document with id '%s' does not exist in mdstore: '%s'", recordId, this.id));
        }
        String body = (String)obj.get("body");
        if (body.trim().length() == 0) {
            throw new DocumentNotFoundException(String.format("The document with id '%s' does not exist in mdstore: '%s'", recordId, this.id));
        }
        return new SerializeMongoRecord().apply(obj);
    }

    public List<String> deliver(String mdId, int pageSize, int offset, Map<String, String> queryParam) {
        QueryBuilder query = QueryBuilder.start();
        for (String key : queryParam.keySet()) {
            query.and(key).regex(Pattern.compile(queryParam.get(key), 16));
        }
        FindIterable dbObjects = offset > 0 ? this.collection.find((Bson)query.get()).limit(pageSize).skip(offset) : this.collection.find((Bson)query.get()).limit(pageSize);
        queryParam.put("count", "" + this.collection.count((Bson)query.get()));
        ArrayList<String> result = new ArrayList<String>();
        for (DBObject item : dbObjects) {
            result.add(item.get("body").toString());
        }
        return result;
    }

    public void truncate() {
        this.collection.drop();
        this.discardedCollection.drop();
    }

    public DBObject getMDStoreMetadata() {
        return (DBObject)this.mongoDatabase.getCollection("metadata", DBObject.class).find((Bson)new BasicDBObject("mdId", (Object)this.getId())).first();
    }

    public String getFormat() {
        return (String)this.getMDStoreMetadata().get("format");
    }

    public String getInterpretation() {
        return (String)this.getMDStoreMetadata().get("interpretation");
    }

    public String getLayout() {
        return (String)this.getMDStoreMetadata().get("layout");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MongoCollection<DBObject> getCollection() {
        return this.collection;
    }

    public void setCollection(MongoCollection<DBObject> collection) {
        this.collection = collection;
    }

    public RecordParser getRecordParser() {
        return this.recordParser;
    }

    @Required
    public void setRecordParser(RecordParser recordParser) {
        this.recordParser = recordParser;
    }

    public int getSize() {
        return (int)this.collection.count();
    }

    public MongoCollection<DBObject> getDiscardedCollection() {
        return this.discardedCollection;
    }

    public void setDiscardedCollection(MongoCollection<DBObject> discardedCollection) {
        this.discardedCollection = discardedCollection;
    }

    private class SerializeMongoRecordId
    implements Function<DBObject, String> {
        private SerializeMongoRecordId() {
        }

        public String apply(DBObject arg) {
            return (String)arg.get("id");
        }
    }

    private class SerializeMongoRecord
    implements Function<DBObject, String> {
        private SerializeMongoRecord() {
        }

        public String apply(DBObject arg) {
            return (String)arg.get("body");
        }
    }
}

