/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.deposit.controller;

import eu.dnetlib.deposit.model.Record;
import eu.dnetlib.deposit.repository.RecordRepository;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/deposit/record"})
public class RecordController {
    @Autowired
    public RecordRepository recordRepository;
    private Logger logger = LogManager.getLogger(this.getClass());

    @GetMapping(value={"get"})
    public List<Record> getRecords(@RequestParam(value="pid") List<String> pid, @RequestParam(value="aaiId") String aaiId, @RequestParam(value="openaireId") String openaireId) {
        this.logger.info("Get records " + String.valueOf(pid));
        return this.recordRepository.findByIdsAndAaiId(pid, openaireId, aaiId);
    }

    @GetMapping(value={"user"})
    public List<Record> getRecords(@RequestParam(value="aaiId") String aaiId) {
        this.logger.info("Get records for user " + aaiId);
        return this.recordRepository.findByAaiIdOrderByDepositDateDesc(aaiId);
    }

    @PostMapping(value={"save"})
    public Record saveRecord(@RequestBody Record record) {
        System.out.println(record);
        record.setDepositDate(new Date());
        return (Record)this.recordRepository.save((Object)record);
    }

    @DeleteMapping(value={"delete"})
    public Boolean saveRecord(@RequestParam(value="id") String id) {
        this.recordRepository.deleteById((Object)id);
        return true;
    }

    @GetMapping(value={"count"})
    public Number getRecords() {
        Long n = this.recordRepository.count();
        this.logger.info("Get total record: " + String.valueOf(n));
        return n;
    }
}

