/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.deposit.controller;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthController {
    private final Logger log = LogManager.getLogger(this.getClass());
    public static Instant dateInstant = Instant.now();
    @Value(value="${services.deposit.zenodo.API}")
    private String zenodoAPI;
    @Value(value="${services.deposit.zenodo.clientId}")
    private String clientId;
    @Value(value="${services.deposit.zenodo.clientSecret}")
    private String clientSecret;
    @Value(value="${services.deposit.redirectURI}")
    private String redirectURI;
    @Value(value="${services.deposit.db.uri}")
    private String dbUri;
    @Value(value="${services.deposit.db.database}")
    private String database;

    @RequestMapping(value={"", "/health_check"}, method={RequestMethod.GET})
    public String hello() {
        this.log.debug("Hello from Deposit service!");
        return "Hello from Deposit service!";
    }

    @RequestMapping(value={"/health_check/advanced"}, method={RequestMethod.GET})
    public Map<String, String> checkEverything() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("Date of deploy", dateInstant.toString());
        response.put("zenodo API", this.zenodoAPI);
        response.put("Redirect", this.redirectURI);
        response.put("DB", this.database);
        return response;
    }
}

