/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.deposit.controller;

import eu.dnetlib.deposit.model.User;
import eu.dnetlib.deposit.repository.UserRepository;
import eu.dnetlib.deposit.service.UserService;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/deposit/user"})
public class UserController {
    @Autowired
    public UserService userService;
    @Autowired
    public UserRepository userRepository;
    private Logger logger = LogManager.getLogger(this.getClass());

    @GetMapping(value={"/token"})
    public User getUser(@RequestParam(value="aaiId") String aaiId) {
        this.logger.info("Get user by aaiId: " + aaiId);
        return this.userService.getUser(aaiId);
    }

    @PostMapping(value={"save"})
    public User saveUser(@RequestBody User user) {
        System.out.println(user);
        user.setLastUpdateDate(new Date());
        return (User)this.userRepository.save((Object)user);
    }

    @GetMapping(value={"count"})
    public Number getRecords() {
        Long n = this.userRepository.count();
        this.logger.info("Get total users: " + String.valueOf(n));
        return n;
    }
}

