/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.deposit.service;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ZenodoAuthService {
    @Value(value="${services.deposit.zenodo.API}")
    private String zenodoAPI;
    @Value(value="${services.deposit.zenodo.clientId}")
    private String clientId;
    @Value(value="${services.deposit.zenodo.clientSecret}")
    private String clientSecret;
    @Value(value="${services.deposit.redirectURI}")
    private String redirectURI;
    private final RestTemplate restTemplate;

    public ZenodoAuthService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getAccessTokenByCode(String code) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"redirect_uri", (Object)this.redirectURI);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"code", (Object)code);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity res = this.restTemplate.postForEntity(this.zenodoAPI + "oauth/token", (Object)request, String.class, new Object[0]);
        return (String)res.getBody();
    }

    public String getAccessTokenByRefresh(String refresh) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"redirect_uri", (Object)this.redirectURI);
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"refresh_token", (Object)refresh);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity res = this.restTemplate.postForEntity(this.zenodoAPI + "oauth/token", (Object)request, String.class, new Object[0]);
        return (String)res.getBody();
    }

    public ResponseEntity<String> getInfo(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = UriComponentsBuilder.fromHttpUrl((String)(this.zenodoAPI + "api/deposit/depositions")).toUriString();
        return this.restTemplate.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
    }
}

