/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.controllers;

import eu.dnetlib.developers.entities.PersonalInfo;
import eu.dnetlib.developers.services.PersonalInfoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personal/"})
public class PersonalInfoController {
    PersonalInfoService service;

    @Autowired
    public PersonalInfoController(PersonalInfoService service) {
        this.service = service;
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<PersonalInfo>> getAll() {
        return ResponseEntity.ok((Object)this.service.getAll());
    }

    @PreAuthorize(value="hasAnyAuthority('REGISTERED_USER')")
    @RequestMapping(value={"/my-info"}, method={RequestMethod.GET})
    public ResponseEntity<PersonalInfo> getMyPersonalInfo() {
        return ResponseEntity.ok((Object)this.service.getPersonalInfo());
    }

    @PreAuthorize(value="hasAnyAuthority('REGISTERED_USER')")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<PersonalInfo> savePersonalInfo(@RequestBody PersonalInfo personalInfo) {
        return ResponseEntity.ok((Object)this.service.savePersonalInfo(personalInfo));
    }
}

