/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.services;

import eu.dnetlib.developers.entities.PersonalInfo;
import eu.dnetlib.developers.repositories.PersonalInfoDAO;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonalInfoService {
    private final PersonalInfoDAO dao;
    private final AuthorizationService authorizationService;

    @Autowired
    public PersonalInfoService(PersonalInfoDAO dao, AuthorizationService authorizationService) {
        this.dao = dao;
        this.authorizationService = authorizationService;
    }

    public List<PersonalInfo> getAll() {
        return this.dao.findAll();
    }

    public PersonalInfo save(PersonalInfo personalInfo) {
        return (PersonalInfo)this.dao.save((Object)personalInfo);
    }

    public PersonalInfo getPersonalInfo() {
        return (PersonalInfo)this.dao.findById(this.authorizationService.getAaiId()).orElseThrow(() -> new NotFoundException("Personal Info of user with id " + this.authorizationService.getAaiId() + " has not been found"));
    }

    public PersonalInfo savePersonalInfo(PersonalInfo personalInfo) {
        personalInfo.setId(this.authorizationService.getAaiId());
        return (PersonalInfo)this.dao.saveAndFlush((Object)personalInfo);
    }
}

