/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.controllers;

import eu.dnetlib.developers.dto.API;
import eu.dnetlib.developers.dto.APIsByIssuer;
import eu.dnetlib.developers.dto.CopyServices;
import eu.dnetlib.developers.dto.ServiceForm;
import eu.dnetlib.developers.services.APIService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/apis"})
public class APIController {
    private APIService service;

    @Autowired
    public APIController(APIService service) {
        this.service = service;
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<APIsByIssuer>> getAll() {
        return ResponseEntity.ok((Object)this.service.getAll());
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value={"/copy"}, method={RequestMethod.POST})
    public ResponseEntity<List<API>> copyServices(@RequestBody CopyServices services) {
        return ResponseEntity.ok((Object)this.service.copyServices(services));
    }

    @PreAuthorize(value="hasAnyAuthority('REGISTERED_USER') && @PermissionService.hasPersonalInfo()")
    @RequestMapping(value={"/my-services"}, method={RequestMethod.GET})
    public ResponseEntity<List<API>> getMyServices() {
        return ResponseEntity.ok((Object)this.service.getMyServices());
    }

    @PreAuthorize(value="hasAnyAuthority('REGISTERED_USER') && @PermissionService.hasPersonalInfo()")
    @RequestMapping(value={"/save/new"}, method={RequestMethod.POST})
    public ResponseEntity<API> create(@RequestBody ServiceForm form) {
        return ResponseEntity.ok((Object)this.service.save(form));
    }

    @PreAuthorize(value="hasAnyAuthority('REGISTERED_USER') && @PermissionService.hasPersonalInfo() && @PermissionService.isMyService(#id)")
    @RequestMapping(value={"/save/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<API> update(@PathVariable Long id, @RequestBody ServiceForm form) {
        return ResponseEntity.ok((Object)this.service.save(form, id));
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR') || (hasAnyAuthority('REGISTERED_USER') && @PermissionService.hasPersonalInfo() && @PermissionService.isMyService(#id))")
    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> delete(@PathVariable Long id) {
        this.service.delete(id);
        return ResponseEntity.noContent().build();
    }
}

