/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.services;

import eu.dnetlib.developers.entities.RegisteredService;
import eu.dnetlib.developers.repositories.PersonalInfoDAO;
import eu.dnetlib.developers.repositories.RegisteredServiceDAO;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="PermissionService")
public class PermissionService {
    private final RegisteredServiceDAO registeredServiceDAO;
    private final PersonalInfoDAO personalInfoDAO;
    private final AuthorizationService authorizationService;

    @Autowired
    public PermissionService(RegisteredServiceDAO registeredServiceDAO, PersonalInfoDAO personalInfoDAO, AuthorizationService authorizationService) {
        this.registeredServiceDAO = registeredServiceDAO;
        this.personalInfoDAO = personalInfoDAO;
        this.authorizationService = authorizationService;
    }

    public boolean isMyService(Long id) {
        RegisteredService service = this.registeredServiceDAO.findById((Object)id).orElse(null);
        return service != null && service.getOwner().equals(this.authorizationService.getAaiId());
    }

    public boolean hasPersonalInfo() {
        return this.personalInfoDAO.findById(this.authorizationService.getAaiId()).orElseThrow(null) != null;
    }
}

