/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.utils;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Arrays;
import java.util.List;

@Converter
public class StringListConverter
implements AttributeConverter<List<String>, String> {
    private static final String ARRAY_DELIMITER = ",";

    public String convertToDatabaseColumn(List<String> attribute) {
        if (attribute == null || attribute.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)ARRAY_DELIMITER, attribute);
    }

    public List<String> convertToEntityAttribute(String dbData) {
        if (dbData == null || dbData.isEmpty()) {
            return null;
        }
        return Arrays.asList(dbData.split(ARRAY_DELIMITER));
    }
}

