/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.developers.configuration.Properties;
import eu.dnetlib.developers.dto.API;
import eu.dnetlib.developers.dto.APIsByIssuer;
import eu.dnetlib.developers.dto.CopyServices;
import eu.dnetlib.developers.dto.Jwks;
import eu.dnetlib.developers.dto.JwksDeserializer;
import eu.dnetlib.developers.dto.ServiceForm;
import eu.dnetlib.developers.dto.ServiceRequest;
import eu.dnetlib.developers.dto.ServiceResponse;
import eu.dnetlib.developers.entities.RegisteredService;
import eu.dnetlib.developers.exceptions.EntityMissingException;
import eu.dnetlib.developers.repositories.RegisteredServiceDAO;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ForbiddenException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class APIService {
    private final RegisteredServiceDAO dao;
    private final RestTemplate template;
    private final String issuer;
    private final AuthorizationService authorizationService;

    @Autowired
    public APIService(RegisteredServiceDAO dao, RestTemplate template, Properties properties, AuthorizationService authorizationService) {
        this.dao = dao;
        this.template = template;
        this.issuer = properties.getIssuer();
        this.authorizationService = authorizationService;
    }

    public List<APIsByIssuer> getAll() {
        ArrayList<String> issuers = new ArrayList<String>(Collections.singletonList(this.issuer));
        issuers.addAll(this.dao.findAllIssuersExceptActive(this.issuer));
        return issuers.stream().map(issuer -> {
            APIsByIssuer apIsByIssuer = new APIsByIssuer(issuer);
            apIsByIssuer.setApis(this.dao.findAllByIssuerOrderByOwnerAsc(issuer).stream().map(service -> {
                API api = new API();
                api.setService(service);
                if (this.issuer.equals(service.getIssuer())) {
                    api.setDetails(this.readService(service.getClientId(), service.getRegistrationAccessToken()));
                }
                return api;
            }).collect(Collectors.toList()));
            return apIsByIssuer;
        }).collect(Collectors.toList());
    }

    public List<API> getMyServices() {
        return this.dao.findAllByOwnerAndIssuerOrderByCreationDateAsc(this.authorizationService.getAaiId(), this.issuer).stream().map(service -> {
            API api = new API();
            api.setService(service);
            api.setDetails(this.readService(service.getClientId(), service.getRegistrationAccessToken()));
            return api;
        }).collect(Collectors.toList());
    }

    public List<API> copyServices(CopyServices services) {
        List<API> apis = this.dao.findAllByIssuerOrderByOwnerAsc(this.issuer).stream().map(service -> {
            API details = new API();
            details.setService(service);
            details.setDetails(this.readService(service.getClientId(), service.getRegistrationAccessToken()));
            return details;
        }).collect(Collectors.toList());
        services.getServices().forEach(element -> {
            RegisteredService service = this.dao.findByClientIdAndIssuer(element.getClientId(), services.getIssuer()).orElse(null);
            RegisteredService newService = this.dao.findByClientIdAndIssuer(element.getClientId(), this.issuer).orElse(null);
            if (service != null && newService == null) {
                newService = new RegisteredService(service, element.getRegistrationAccessToken(), this.issuer);
                API api = new API();
                api.setService((RegisteredService)this.dao.save((Object)newService));
                api.setDetails(this.readService(service.getClientId(), service.getRegistrationAccessToken()));
                apis.add(api);
            }
        });
        return apis;
    }

    public API save(ServiceForm form, Long id) {
        ServiceResponse response;
        ServiceRequest request;
        API api = new API();
        if (id != null) {
            RegisteredService service = this.dao.findById((Object)id).orElse(null);
            if (service == null) {
                throw new NotFoundException("Service with id " + id + " does not exist.");
            }
            api.setService(service);
            api.setDetails(this.readService(service.getClientId(), service.getRegistrationAccessToken()));
        } else {
            api.setService(new RegisteredService(this.authorizationService.getAaiId(), this.issuer));
        }
        String keyType = form.getKeyType();
        if (keyType != null && keyType.equals("uri")) {
            if (form.getUri() == null) {
                throw new EntityMissingException("Uri is required in this type of key");
            }
            request = ServiceRequest.createServiceRequest((String)api.getService().getClientId(), (String)form.getName(), (String)form.getLogoURL(), (List)form.getContacts(), (String)form.getUri());
        } else if (keyType != null && keyType.equals("value")) {
            Gson gson = new GsonBuilder().registerTypeAdapter(Jwks.class, (Object)new JwksDeserializer()).create();
            String jwksSet = String.format("{\"keys\":[%s]}", form.getValue());
            form.setJwks((Jwks)gson.fromJson(jwksSet, Jwks.class));
            if (!form.getJwks().isValid()) {
                throw new NotFoundException("Jwks value is not valid");
            }
            request = ServiceRequest.createServiceRequest((String)api.getService().getClientId(), (String)form.getName(), (String)form.getLogoURL(), (List)form.getContacts(), (Jwks)form.getJwks());
        } else {
            request = ServiceRequest.createServiceRequest((String)api.getService().getClientId(), (String)form.getName(), (String)form.getLogoURL(), (List)form.getContacts());
        }
        if (api.getService().getClientId() != null) {
            response = this.updateService(api.getService().getClientId(), request, api.getService().getRegistrationAccessToken());
        } else if (this.dao.findAllByOwnerAndIssuerOrderByCreationDateAsc(this.authorizationService.getAaiId(), this.issuer).size() < 5) {
            response = this.createService(request);
        } else {
            throw new ForbiddenException("You are not allowed to own more than 5 services.");
        }
        api.getService().setService(form, response);
        api.setService((RegisteredService)this.dao.save((Object)api.getService()));
        api.setDetails(response);
        return api;
    }

    public API save(ServiceForm form) {
        return this.save(form, null);
    }

    public void delete(Long id) {
        RegisteredService service = this.dao.findById((Object)id).orElse(null);
        if (service == null) {
            throw new NotFoundException("Service with id " + id + " does not exist.");
        }
        if (this.readService(service.getClientId(), service.getRegistrationAccessToken()) != null) {
            this.deleteService(service.getClientId(), service.getRegistrationAccessToken());
        }
        this.dao.delete((Object)service);
    }

    private ServiceResponse createService(ServiceRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)request.toJson(), (MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.issuer, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            return ServiceResponse.fromString((String)((String)response.getBody()));
        }
        catch (Exception e) {
            throw new EntityMissingException("Register of this service couldn't be completed. Check again your parameters");
        }
    }

    private ServiceResponse updateService(String clientId, ServiceRequest request, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        HttpEntity requestEntity = new HttpEntity((Object)request.toJson(), (MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.issuer + "/" + clientId, HttpMethod.PUT, requestEntity, String.class, new Object[0]);
            return ServiceResponse.fromString((String)((String)response.getBody()));
        }
        catch (Exception e) {
            throw new EntityMissingException("Update of service with client id: " + clientId + " couldn't be completed. Check again your parameters");
        }
    }

    private ServiceResponse readService(String clientId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.issuer + "/" + clientId, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            return ServiceResponse.fromString((String)((String)response.getBody()));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void deleteService(String clientId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            this.template.exchange(this.issuer + "/" + clientId, HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            throw new EntityMissingException("Delete of service with client id: " + clientId + " couldn't be completed. Check again your parameters");
        }
    }
}

