/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.developers.services;

import eu.dnetlib.developers.configuration.GlobalVars;
import eu.dnetlib.developers.configuration.Properties;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeployService {
    private final Properties properties;
    private final GlobalVars globalVars;

    @Autowired
    public DeployService(Properties properties, GlobalVars globalVars) {
        this.properties = properties;
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.properties.getDatasource().getUrl() == null || this.properties.getDatasource().getUrl().isEmpty()) {
            throw new RuntimeException("developers.datasource.url is missing!");
        }
        if (this.properties.getIssuer() == null || this.properties.getIssuer().isEmpty()) {
            throw new RuntimeException("developers.issuer is missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("developers.datasource.url", this.properties.getDatasource().getUrl());
        response.put("developers.datasource.username", this.properties.getDatasource().getUsername());
        response.put("developers.datasource.password", this.properties.getDatasource().getPassword());
        response.put("developers.issuer", this.properties.getIssuer());
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

