/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.scraper;

import eu.dnetlib.bioschemas.api.ServiceScrapeDriver;
import eu.dnetlib.bioschemas.api.scraper.ScrapingExecution;
import eu.dnetlib.bioschemas.api.scraper.ScrapingStatus;
import org.springframework.stereotype.Component;

@Component
public class ScrapingExecutor {
    private final ScrapingExecution lastScrapingExecution = new ScrapingExecution();

    public ScrapingExecution getLastScrapingExecution() {
        return this.lastScrapingExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrapingExecution startScraping(String datasourceKey, String sitemapUrl, String outputDataPattern, String remoteAddr, String outputFolder) {
        ScrapingExecution scrapingExecution = this.lastScrapingExecution;
        synchronized (scrapingExecution) {
            if (this.lastScrapingExecution.getStatus() == ScrapingStatus.RUNNING) {
                long now = System.currentTimeMillis();
                return new ScrapingExecution(null, Long.valueOf(now), Long.valueOf(now), ScrapingStatus.NOT_LAUNCHED, "An other scraping is running");
            }
            this.lastScrapingExecution.startNew("Scraping for " + datasourceKey + " " + sitemapUrl + " - request from " + remoteAddr);
            new Thread(() -> {
                try {
                    String sitemapUrlKey = "loc";
                    String outputFilename = datasourceKey.concat(outputDataPattern);
                    ServiceScrapeDriver service = new ServiceScrapeDriver(sitemapUrl, sitemapUrlKey, null, outputFilename, outputFolder);
                    service.runScrape();
                    this.lastScrapingExecution.complete();
                }
                catch (Throwable e) {
                    this.lastScrapingExecution.fail(e);
                }
            }).start();
        }
        return this.lastScrapingExecution;
    }
}

