/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.scraper;

import eu.dnetlib.bioschemas.api.crawl.CrawlRecord;
import eu.dnetlib.bioschemas.api.crawl.StatusOfScrape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ScrapeState {
    private List<CrawlRecord> urlsToScrape = Collections.synchronizedList(new ArrayList());
    private List<CrawlRecord> urlsProcessed = Collections.synchronizedList(new ArrayList());
    private Map<String, Object> nquadsConcurrentHashMap = new ConcurrentHashMap();

    public ScrapeState(List<CrawlRecord> pagesToBeScraped) {
        this.urlsToScrape.addAll(pagesToBeScraped);
    }

    public synchronized boolean pagesLeftToScrape() {
        return !this.urlsToScrape.isEmpty();
    }

    public synchronized CrawlRecord getURLToProcess() {
        if (this.urlsToScrape.isEmpty()) {
            return null;
        }
        return (CrawlRecord)this.urlsToScrape.remove(0);
    }

    public synchronized void addSuccessfulScrapedURL(CrawlRecord record) {
        record.setStatus(StatusOfScrape.SUCCESS);
        this.urlsProcessed.add(record);
    }

    public synchronized void addFailedToScrapeURL(CrawlRecord record) {
        if (record.getStatus().equals((Object)StatusOfScrape.FAILED)) {
            record.setStatus(StatusOfScrape.GIVEN_UP);
        } else {
            record.setStatus(StatusOfScrape.FAILED);
        }
        this.urlsProcessed.add(record);
    }

    public synchronized void setStatusTo404(CrawlRecord record) {
        record.setStatus(StatusOfScrape.DOES_NOT_EXIST);
        this.urlsProcessed.add(record);
    }

    public synchronized void setStatusToHumanInspection(CrawlRecord record) {
        record.setStatus(StatusOfScrape.HUMAN_INSPECTION);
        this.urlsProcessed.add(record);
    }

    public synchronized int getNumberPagesLeftToScrape() {
        return this.urlsToScrape.size();
    }

    public synchronized List<CrawlRecord> getPagesProcessed() {
        return this.urlsProcessed;
    }

    public synchronized List<CrawlRecord> getPagesProcessedAndUnprocessed() {
        List<CrawlRecord> urlsCombined = Collections.synchronizedList(new ArrayList());
        urlsCombined.addAll(this.urlsProcessed);
        urlsCombined.addAll(this.urlsToScrape);
        return urlsCombined;
    }

    public void addNquads(String key, String nquads) {
        this.nquadsConcurrentHashMap.putIfAbsent(key, nquads);
    }

    public Map<String, Object> getNquadsConcurrentHashMap() {
        return this.nquadsConcurrentHashMap;
    }
}

