/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.ror;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.ror.model.ExternalIdType;
import eu.dnetlib.dhp.actionmanager.ror.model.RorOrganization;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class GenerateRorActionSetJob {
    private static final Logger log = LoggerFactory.getLogger(GenerateRorActionSetJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final List<KeyValue> ROR_COLLECTED_FROM = OafMapperUtils.listKeyValues((String[])new String[]{"10|openaire____::993a7ae7a863813cf95028b50708e222", "Research Organization Registry (ROR)"});
    private static final DataInfo ROR_DATA_INFO = OafMapperUtils.dataInfo((Boolean)false, (String)"", (Boolean)false, (Boolean)false, (Qualifier)ModelConstants.ENTITYREGISTRY_PROVENANCE_ACTION, (String)"0.92");
    private static final Qualifier ROR_PID_TYPE = OafMapperUtils.qualifier((String)"ROR", (String)"ROR", (String)"dnet:pid_types", (String)"dnet:pid_types");

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)GenerateRorActionSetJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/ror/action_set_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            GenerateRorActionSetJob.removeOutputDir(spark, outputPath);
            GenerateRorActionSetJob.processRorOrganizations(spark, inputPath, outputPath);
        });
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    private static void processRorOrganizations(SparkSession spark, String inputPath, String outputPath) throws IOException {
        GenerateRorActionSetJob.readInputPath(spark, inputPath).map(GenerateRorActionSetJob::convertRorOrg).flatMap(List::iterator).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa)))).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class);
    }

    protected static List<AtomicAction<? extends Oaf>> convertRorOrg(RorOrganization r) {
        Date now = new Date();
        Organization o = new Organization();
        o.setId(GenerateRorActionSetJob.calculateOpenaireId(r.getId()));
        o.setOriginalId(Arrays.asList(String.format("%s::%s", "ror_________", r.getId())));
        o.setCollectedfrom(ROR_COLLECTED_FROM);
        o.setPid(GenerateRorActionSetJob.pids(r));
        o.setDateofcollection(now.toString());
        o.setDateoftransformation(now.toString());
        o.setExtraInfo(new ArrayList());
        o.setOaiprovenance(null);
        o.setLegalshortname(OafMapperUtils.field((Object)r.getAcronyms().stream().findFirst().orElse(r.getName()), (DataInfo)ROR_DATA_INFO));
        o.setLegalname(OafMapperUtils.field((Object)r.getName(), (DataInfo)ROR_DATA_INFO));
        o.setAlternativeNames(GenerateRorActionSetJob.alternativeNames(r));
        o.setWebsiteurl(OafMapperUtils.field(r.getLinks().stream().findFirst().orElse(null), (DataInfo)ROR_DATA_INFO));
        o.setLogourl(null);
        o.setEclegalbody(null);
        o.setEclegalperson(null);
        o.setEcnonprofit(null);
        o.setEcresearchorganization(null);
        o.setEchighereducation(null);
        o.setEcinternationalorganizationeurinterests(null);
        o.setEcinternationalorganization(null);
        o.setEcenterprise(null);
        o.setEcsmevalidated(null);
        o.setEcnutscode(null);
        if (r.getCountry() != null) {
            o.setCountry(OafMapperUtils.qualifier((String)r.getCountry().getCountryCode(), (String)r.getCountry().getCountryName(), (String)"dnet:countries", (String)"dnet:countries"));
        } else {
            o.setCountry(null);
        }
        o.setDataInfo(ROR_DATA_INFO);
        o.setLastupdatetimestamp(Long.valueOf(now.getTime()));
        ArrayList<AtomicAction<? extends Oaf>> res = new ArrayList<AtomicAction<? extends Oaf>>();
        res.add(new AtomicAction(Organization.class, (Oaf)o));
        return res;
    }

    public static String calculateOpenaireId(String rorId) {
        return String.format("20|%s::%s", "ror_________", DHPUtils.md5((String)rorId));
    }

    private static List<StructuredProperty> pids(RorOrganization r) {
        ArrayList<StructuredProperty> pids = new ArrayList<StructuredProperty>();
        pids.add(OafMapperUtils.structuredProperty((String)r.getId(), (Qualifier)ROR_PID_TYPE, (DataInfo)ROR_DATA_INFO));
        for (Map.Entry<String, ExternalIdType> e : r.getExternalIds().entrySet()) {
            String type = e.getKey();
            List<String> all = e.getValue().getAll();
            if (all == null) continue;
            Qualifier qualifier = OafMapperUtils.qualifier((String)type, (String)type, (String)"dnet:pid_types", (String)"dnet:pid_types");
            for (String pid : all) {
                pids.add(OafMapperUtils.structuredProperty((String)pid, (Qualifier)qualifier, (DataInfo)ROR_DATA_INFO));
            }
        }
        return pids;
    }

    private static List<Field<String>> alternativeNames(RorOrganization r) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.addAll(r.getAliases());
        names.addAll(r.getAcronyms());
        r.getLabels().forEach(l -> names.add(l.getLabel()));
        return names.stream().filter(StringUtils::isNotBlank).map(s -> OafMapperUtils.field((Object)s, (DataInfo)ROR_DATA_INFO)).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private static JavaRDD<RorOrganization> readInputPath(SparkSession spark, String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

