/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection;

import eu.dnetlib.dhp.aggregation.common.ReporterCallback;
import eu.dnetlib.dhp.aggregation.common.ReportingJob;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.UnknownCollectorPluginException;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.base.BaseCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.dblp.DBLPCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.file.FileCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.file.FileGZipCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.gtr2.Gtr2PublicationsCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.mongodb.MDStoreCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.mongodb.MongoDbDumpCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.oai.OaiCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.osf.OsfPreprintsCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.researchfi.ResearchFiCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.rest.RestCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.zenodo.CollectZenodoDumpCollectorPlugin;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DeflateCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorWorker
extends ReportingJob {
    private static final Logger log = LoggerFactory.getLogger(CollectorWorker.class);
    private final ApiDescriptor api;
    private final FileSystem fileSystem;
    private final MDStoreVersion mdStoreVersion;
    private final HttpClientParams clientParams;

    public CollectorWorker(ApiDescriptor api, FileSystem fileSystem, MDStoreVersion mdStoreVersion, HttpClientParams clientParams, AggregatorReport report) {
        super(report);
        this.api = api;
        this.fileSystem = fileSystem;
        this.mdStoreVersion = mdStoreVersion;
        this.clientParams = clientParams;
    }

    public void collect() throws UnknownCollectorPluginException, CollectorException, IOException {
        String outputPath = this.mdStoreVersion.getHdfsPath() + "/sequence_file";
        log.info("outputPath path is {}", (Object)outputPath);
        CollectorPlugin plugin = this.getCollectorPlugin();
        AtomicInteger counter = new AtomicInteger(0);
        this.scheduleReport(counter);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)this.fileSystem.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(outputPath)), SequenceFile.Writer.keyClass(IntWritable.class), SequenceFile.Writer.valueClass(Text.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DeflateCodec())});){
            IntWritable key = new IntWritable(counter.get());
            Text value = new Text();
            plugin.collect(this.api, this.report).forEach(content -> {
                key.set(counter.getAndIncrement());
                value.set(content);
                try {
                    writer.append((Writable)key, (Writable)value);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable e) {
            this.report.put((Object)e.getClass().getName(), (Object)e.getMessage());
            throw new CollectorException(e);
        }
        finally {
            this.shutdown();
            this.report.ongoing(Long.valueOf(counter.longValue()), Long.valueOf(counter.longValue()));
        }
    }

    private void scheduleReport(final AtomicInteger counter) {
        this.schedule(new ReporterCallback(){

            @Override
            public Long getCurrent() {
                return counter.longValue();
            }

            @Override
            public Long getTotal() {
                return null;
            }
        });
    }

    private CollectorPlugin getCollectorPlugin() throws UnknownCollectorPluginException {
        switch (CollectorPlugin.NAME.valueOf(this.api.getProtocol())) {
            case oai: {
                return new OaiCollectorPlugin(this.clientParams);
            }
            case rest_json2xml: {
                return new RestCollectorPlugin(this.clientParams);
            }
            case file: {
                return new FileCollectorPlugin(this.fileSystem);
            }
            case fileGzip: {
                return new FileGZipCollectorPlugin(this.fileSystem);
            }
            case baseDump: {
                return new BaseCollectorPlugin(this.fileSystem);
            }
            case gtr2Publications: {
                return new Gtr2PublicationsCollectorPlugin(this.clientParams);
            }
            case osfPreprints: {
                return new OsfPreprintsCollectorPlugin(this.clientParams);
            }
            case zenodoDump: {
                return new CollectZenodoDumpCollectorPlugin(this.fileSystem);
            }
            case dblp: {
                return new DBLPCollectorPlugin(this.fileSystem);
            }
            case research_fi: {
                return new ResearchFiCollectorPlugin();
            }
            case other: {
                CollectorPlugin.NAME.OTHER_NAME plugin = Optional.ofNullable(this.api.getParams().get("other_plugin_type")).map(CollectorPlugin.NAME.OTHER_NAME::valueOf).orElseThrow(() -> new IllegalArgumentException("invalid other_plugin_type"));
                switch (plugin) {
                    case mdstore_mongodb_dump: {
                        return new MongoDbDumpCollectorPlugin(this.fileSystem);
                    }
                    case mdstore_mongodb: {
                        return new MDStoreCollectorPlugin();
                    }
                }
                throw new UnknownCollectorPluginException("plugin is not managed: " + (Object)((Object)plugin));
            }
        }
        throw new UnknownCollectorPluginException("protocol is not managed: " + this.api.getProtocol());
    }
}

