/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.elasticsearch.EventStatsManager;
import eu.dnetlib.broker.common.elasticsearch.SuggestionEventRepository;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/events"})
@Tag(name="Events")
public class EventsController
extends AbstractDnetController {
    private static final Log log = LogFactory.getLog(AbstractDnetController.class);
    @Autowired
    private SuggestionEventRepository suggestionEventRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private EventStatsManager eventStatsManager;

    @Operation(summary="Return an event by ID")
    @GetMapping(value={"/{id}"})
    public Event getEvent(@PathVariable String id) {
        return (Event)this.suggestionEventRepository.findById((Object)id).get();
    }

    @Operation(summary="Delete an event by ID")
    @DeleteMapping(value={"/{id}"})
    public void deleteEvent(@PathVariable String id) {
        this.suggestionEventRepository.deleteById((Object)id);
    }

    @Operation(summary="Return a page of events")
    @GetMapping(value={"/list/{page}/{pageSize}"})
    public List<Event> events(@PathVariable int page, @PathVariable int pageSize, @RequestParam(required=false) String type) {
        return Lists.newArrayList((Iterable)this.suggestionEventRepository.findAll((Pageable)PageRequest.of((int)page, (int)pageSize)));
    }

    @Operation(summary="Return a page of events by topic")
    @GetMapping(value={"/byTopic/{page}/{pageSize}"})
    public List<Event> eventsByTopic(@PathVariable int page, @PathVariable int pageSize, @RequestParam String topic, @RequestParam(required=false) String type) {
        return Lists.newArrayList((Iterable)this.suggestionEventRepository.findByTopic(topic, (Pageable)PageRequest.of((int)page, (int)pageSize)));
    }

    @Operation(summary="Delete all the events")
    @DeleteMapping(value={"/all"})
    public Map<String, Object> clearEvents(@RequestParam(required=false) String type) {
        this.suggestionEventRepository.deleteAll();
        log.info((Object)"Deleted all suggestion events");
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("deleted", true);
        return res;
    }

    @Operation(summary="Delete the expired events")
    @DeleteMapping(value={"/expired"})
    public Map<String, Object> deleteExpiredEvents(@RequestParam(required=false) String type) {
        return this.deleteEventsByExpiryDate(0L, new Date().getTime(), type);
    }

    @Operation(summary="Delete the events with the creationDate in a range")
    @DeleteMapping(value={"/byCreationDate/{from}/{to}"})
    public Map<String, Object> deleteEventsByCreationDate(@PathVariable long from, @PathVariable long to, @RequestParam(required=false) String type) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("deleted", this.suggestionEventRepository.deleteByCreationDateBetween(from, to));
        res.put("from", from);
        res.put("to", to);
        res.put("type", StringUtils.firstNonBlank((CharSequence[])new String[]{type, "suggestion"}));
        log.info((Object)String.format("Deleted %s events in creationDate range %s-%s", res.get("deleted"), from, to));
        return res;
    }

    @Operation(summary="Delete the events with the expiryDate in a range")
    @DeleteMapping(value={"/byExpiryDate/{from}/{to}"})
    public Map<String, Object> deleteEventsByExpiryDate(@PathVariable long from, @PathVariable long to, @RequestParam(required=false) String type) {
        new Thread(() -> {
            long n = this.suggestionEventRepository.deleteByExpiryDateBetween(from, to);
            log.info((Object)String.format("Deleted %s events in expiryDate range %s-%s", n, from, to));
        }).start();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("status", "deleting...");
        res.put("from", from);
        res.put("to", to);
        return res;
    }

    @Operation(summary="Return the topics of the indexed events (all)")
    @GetMapping(value={"/topics/all"})
    public List<EventStatsManager.BrowseEntry> browseTopics() {
        return this.eventStatsManager.browseTopics();
    }

    @Operation(summary="Return the topics of the indexed events (only with subscriptions)")
    @GetMapping(value={"/topics/withSubscriptions"})
    public List<EventStatsManager.BrowseEntry> browseTopicsWithSubscriptions() {
        List iter = this.subscriptionRepo.findAll();
        Set validTopics = StreamSupport.stream(iter.spliterator(), false).map(Subscription::getTopic).collect(Collectors.toSet());
        return this.browseTopics().stream().filter(e -> validTopics.contains(e.getValue())).collect(Collectors.toList());
    }
}

