#!/bin/bash

INDEXBASEURL=http://localhost:9200 # USE A SSH PROXY 
EVENTINDEXNAME=oa_events_prod
NOTIFICATIONINDEXNAME=oa_notifications_prod
ALERTNOTIFICATIONINDEXNAME=oa_alert_notifications_prod

echo
echo "Create the events index..."
curl -XPUT -H 'Content-Type: application/json' "$INDEXBASEURL/$EVENTINDEXNAME" -d '
{
    "mappings" : {
      "properties" : {
        "creationDate" : {
          "type" : "long"
        },
        "eventId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "expiryDate" : {
          "type" : "long"
        },
        "instantMessage" : {
          "type" : "boolean"
        },
        "map" : {
          "type" : "nested",
          "properties" : {
            "provenanceDatasourceId" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "provenanceDatasourceName" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "provenanceDatasourceType" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "provenanceResultId" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetAuthors" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetDatasourceId" : {
              "type" : "keyword"
            },
            "targetDatasourceName" : {
              "type" : "keyword"
            },
            "targetDatasourceType" : {
              "type" : "keyword"
            },
            "targetDateofacceptance" : {
              "type" : "long"
            },
            "targetResultId" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetResultTitle" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetSubjects" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "trust" : {
              "type" : "float"
            }
          }
        },
        "payload" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "producerId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "topic" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        }
      }
    },
    "settings" : {
      "index" : {
        "refresh_interval" : "600s",
        "number_of_shards" : "48",
        "translog" : {
          "sync_interval" : "15s",
          "durability" : "ASYNC"
        },
        "store" : {
          "type" : "fs"
        },
        "analysis" : {
          "analyzer" : {
            "analyzer_keyword" : {
              "filter" : "lowercase",
              "tokenizer" : "keyword"
            }
          }
        },
        "number_of_replicas" : "0"
      }
    }
}'


echo
echo "Create the notifications index..."
curl -XPUT -H 'Content-Type: application/json' "$INDEXBASEURL/$NOTIFICATIONINDEXNAME" -d '
{
    "mappings" : {
      "properties" : {
        "date" : {
          "type" : "long"
        },
        "eventId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "map" : {
          "type" : "nested",
          "properties" : {
            "provenanceDatasourceId" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "provenanceDatasourceName" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "provenanceDatasourceType" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "provenanceResultId" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetAuthors" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetDatasourceId" : {
              "type" : "keyword"
            },
            "targetDatasourceName" : {
              "type" : "keyword"
            },
            "targetDatasourceType" : {
              "type" : "keyword"
            },
            "targetDateofacceptance" : {
              "type" : "long"
            },
            "targetResultId" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetResultTitle" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "targetSubjects" : {
              "type" : "text",
              "fields" : {
                "keyword" : {
                  "type" : "keyword",
                  "ignore_above" : 256
                }
              }
            },
            "trust" : {
              "type" : "float"
            }
          }
        },
        "notificationId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "payload" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "producerId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "subscriptionId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "topic" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        }
      }
    },
    "settings" : {
      "index" : {
        "refresh_interval" : "600s",
        "number_of_shards" : "48",
        "translog" : {
          "sync_interval" : "15s",
          "durability" : "ASYNC"
        },
        "store" : {
          "type" : "fs"
        },
        "analysis" : {
          "analyzer" : {
            "analyzer_keyword" : {
              "filter" : "lowercase",
              "tokenizer" : "keyword"
            }
          }
        },
        "number_of_replicas" : "0"
      }
    }
}'

echo
echo "Create the ALERT notifications index..."
curl -XPUT -H 'Content-Type: application/json' "$INDEXBASEURL/$ALERTNOTIFICATIONINDEXNAME" -d '{
    "mappings": {
      "properties": {
        "_class": {
          "type": "keyword",
          "index": false,
          "doc_values": false
        },
        "date": {
          "type": "long"
        },
        "eventId": {
          "type": "text",
          "fields": {
            "keyword": {
              "type": "keyword",
              "ignore_above": 256
            }
          }
        },
        "map": {
          "type": "nested",
          "properties": {
            "datasourceId": {
              "type" : "keyword"
            },
            "datasourceName": {
              "type" : "keyword"
            },
            "originalId": {
              "type" : "keyword"
            },
            "title": {
              "type" : "keyword"
            }
          }
        },
        "notificationId": {
          "type": "text",
          "fields": {
            "keyword": {
              "type": "keyword",
              "ignore_above": 256
            }
          }
        },
        "payload": {
          "type": "text",
          "fields": {
            "keyword": {
              "type": "keyword",
              "ignore_above": 256
            }
          }
        },
        "producerId": {
          "type": "text",
          "fields": {
            "keyword": {
              "type": "keyword",
              "ignore_above": 256
            }
          }
        },
        "subscriptionId": {
          "type": "text",
          "fields": {
            "keyword": {
              "type": "keyword",
              "ignore_above": 256
            }
          }
        },
        "topic": {
          "type": "text",
          "fields": {
            "keyword": {
              "type": "keyword",
              "ignore_above": 256
            }
          }
        }
      }
    }
}'
echo
echo
