/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker;

import eu.dnetlib.broker.BrokerUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@Deprecated
public class BrokerClientApp
implements CommandLineRunner {
    private static Logger log = LoggerFactory.getLogger(BrokerClientApp.class);
    private static final String APPLICATION_NAME = "oa-broker-client";
    private static final String APPLICATION_TITLE = "OpenAIRE Broker - Public API Client";
    private static final String APPLICATION_FOOTER = "\nSee http://api.openaire.eu/broker for further details.\n";
    @Value(value="${dhp.broker.api.base-url}")
    private String defaultBrokerApiBaseUrl;
    @Autowired
    private BrokerUtils brokerUtils;
    private static final CommandLineParser cmdLineParser = new DefaultParser();
    private static final Options options = new Options().addOption(Option.builder((String)"u").required(true).hasArg(true).longOpt("user").desc("the email of the subscriber (REQUIRED)").build()).addOption(Option.builder((String)"bu").required(false).hasArg(true).longOpt("baseurl").desc("override of the default Broker Public Api baseUrl").build()).addOption(Option.builder((String)"o").required(true).hasArg(true).longOpt("output").desc("the output directory (REQUIRED)").build()).addOption(Option.builder((String)"z").required(false).hasArg(false).desc("compress the output files in GZIP format").build()).addOption(Option.builder((String)"i").required(false).hasArg(false).desc("interactive mode").build()).addOption(Option.builder((String)"h").longOpt("help").required(false).hasArg(false).desc("help").build()).addOption(Option.builder((String)"v").required(false).hasArg(false).desc("verbose").build()).addOption(Option.builder((String)"vv").required(false).hasArg(false).desc("show debug logs").build());

    public static void main(String[] args) {
        for (String s : args) {
            if (!s.equals("-h") && !s.equals("--help")) continue;
            BrokerClientApp.printHelpAndExit((Options)options);
        }
        try {
            CommandLine cmd = cmdLineParser.parse(options, args, false);
            if (cmd.hasOption("v")) {
                SpringApplication.run(BrokerClientApp.class, (String[])((String[])ArrayUtils.add((Object[])args, (Object)"--logging.level.root=INFO")));
            } else if (cmd.hasOption("vv")) {
                SpringApplication.run(BrokerClientApp.class, (String[])((String[])ArrayUtils.add((Object[])args, (Object)"--logging.level.root=DEBUG")));
            } else {
                SpringApplication.run(BrokerClientApp.class, (String[])args);
            }
        }
        catch (ParseException e) {
            System.err.println("\nERROR: " + e.getMessage());
            BrokerClientApp.printHelpAndExit((Options)options);
        }
    }

    public void run(String ... args) throws Exception {
        System.out.println();
        log.info("**** EXECUTING - BrokerClientApp ***");
        CommandLine cmd = cmdLineParser.parse(options, args, true);
        String user = cmd.getOptionValue("u");
        URL baseUrl = new URL(cmd.getOptionValue("bu", this.defaultBrokerApiBaseUrl));
        File outputDir = this.prepareDir(cmd.getOptionValue("o"));
        boolean gzip = cmd.hasOption("z");
        boolean interactive = cmd.hasOption("i");
        log.info("* PARAMS: USER: " + user);
        log.info("* PARAMS: BASE_URL: " + baseUrl);
        log.info("* PARAMS: OUTPUT DIR: " + outputDir);
        log.info("* PARAMS: SAVE AS GZIP: " + gzip);
        log.info("* PARAMS: INTERACTIVE MODE: " + interactive);
        for (String s : this.brokerUtils.listSubscriptions(baseUrl, user)) {
            if (!interactive || this.confirm(s)) {
                this.brokerUtils.downloadEvents(baseUrl, s, outputDir, gzip);
                continue;
            }
            System.out.println("-- SKIPPED --");
        }
        log.info("**** DONE ***");
        System.out.println();
    }

    private boolean confirm(String s) throws IOException {
        System.out.print(String.format("\nDo you want download subscription %s? (Y/N) ", s));
        System.out.flush();
        char c = (char)System.in.read();
        while (c != 'y' && c != 'Y') {
            if (c == 'n' || c == 'N') {
                return false;
            }
            c = (char)System.in.read();
        }
        return true;
    }

    private File prepareDir(String path) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            log.info("Reusing existent directory: " + path);
            return dir;
        }
        if (!dir.exists() && dir.mkdirs()) {
            log.info("New directory created: " + path);
            return dir;
        }
        log.error("Invalid directory: " + path);
        throw new RuntimeException("Invalid directory: " + path);
    }

    private static void printHelpAndExit(Options options) {
        String ln = StringUtils.repeat((String)"=", (int)"OpenAIRE Broker - Public API Client".length());
        System.out.println(String.format("\n%s\n%s\n%s\n", ln, "OpenAIRE Broker - Public API Client", ln));
        new HelpFormatter().printHelp("oa-broker-client", options, true);
        System.out.println("\nSee http://api.openaire.eu/broker for further details.\n");
        System.exit(1);
    }
}

