package eu.dnetlib.broker;

import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;
import org.springframework.data.elasticsearch.config.AbstractElasticsearchConfiguration;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import eu.dnetlib.broker.common.elasticsearch.AlertNotification;
import eu.dnetlib.broker.common.elasticsearch.SuggestionEvent;
import eu.dnetlib.broker.common.elasticsearch.SuggestionNotification;
import eu.dnetlib.broker.common.feedbacks.DbEventFeedback;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import eu.dnetlib.broker.common.stats.OpenaireDsStat;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.topics.TopicType;

@Configuration
@EnableCaching
@EnableScheduling
@EnableTransactionManagement
@EnableElasticsearchRepositories(basePackageClasses = {
		SuggestionEvent.class, SuggestionNotification.class, AlertNotification.class
})
@EnableJpaRepositories(basePackageClasses = {
		DbEventFeedback.class, OpenaireDsStat.class, Subscription.class, TopicType.class
})
@ComponentScan(basePackages = "eu.dnetlib")
public class BrokerConfiguration extends AbstractElasticsearchConfiguration {

	@Autowired
	private ElasticSearchProperties elasticSearchProperties;

	@Override
	@Bean
	public RestHighLevelClient elasticsearchClient() {
		final ClientConfiguration clientConfiguration = ClientConfiguration.builder()
				.connectedTo(elasticSearchProperties.getClusterNodes().split(","))
				.withConnectTimeout(elasticSearchProperties.getConnectionTimeout())
				.withSocketTimeout(elasticSearchProperties.getSocketTimeout())
				.build();
		return RestClients.create(clientConfiguration).rest();
	}

}
