/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DbClient.class);
    private final Connection connection;

    public DbClient(String address, String login, String password) {
        try {
            Class.forName("org.postgresql.Driver");
            this.connection = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{login, password}) ? DriverManager.getConnection(address, login, password) : DriverManager.getConnection(address);
            this.connection.setAutoCommit(false);
        }
        catch (Exception e) {
            log.error("Connection to postgresDB failed");
            throw new RuntimeException("Connection to postgresDB failed", e);
        }
        log.info("Opened database successfully");
    }

    public void processResults(String sql, Consumer<ResultSet> consumer) {
        try (Statement stmt = this.connection.createStatement();){
            stmt.setFetchSize(100);
            log.info("running SQL:\n\n{}\n\n", (Object)sql);
            try (ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    consumer.accept(rs);
                }
            }
            catch (SQLException e) {
                log.error("Error executing sql query: " + sql, (Throwable)e);
                throw new RuntimeException("Error executing sql query", e);
            }
        }
        catch (SQLException e1) {
            log.error("Error preparing sql statement", (Throwable)e1);
            throw new RuntimeException("Error preparing sql statement", e1);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

