/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.oa.dedup.DatePicker;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.OafEntityType;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.codehaus.jackson.map.ObjectMapper;
import scala.Tuple2;

public class DedupRecordFactory {
    public static JavaRDD<OafEntity> createDedupRecord(JavaSparkContext sc, SparkSession spark, String mergeRelsInputPath, String entitiesInputPath, OafEntityType entityType, DedupConfig dedupConf) {
        long ts = System.currentTimeMillis();
        JavaPairRDD inputJsonEntities = sc.textFile(entitiesInputPath).mapToPair((PairFunction & Serializable)it -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)dedupConf.getWf().getIdPath(), (String)it), it));
        JavaPairRDD mergeRels = spark.read().load(mergeRelsInputPath).as(Encoders.bean(Relation.class)).where("relClass=='merges'").javaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getTarget(), (Object)r.getSource()));
        JavaPairRDD joinResult = mergeRels.join(inputJsonEntities).mapToPair(Tuple2::_2);
        JavaPairRDD sortedJoinResult = joinResult.groupByKey();
        switch (entityType) {
            case publication: {
                return sortedJoinResult.map((Function & Serializable)p -> DedupRecordFactory.publicationMerger((Tuple2<String, Iterable<String>>)p, ts));
            }
            case dataset: {
                return sortedJoinResult.map((Function & Serializable)d -> DedupRecordFactory.datasetMerger((Tuple2<String, Iterable<String>>)d, ts));
            }
            case project: {
                return sortedJoinResult.map((Function & Serializable)p -> DedupRecordFactory.projectMerger((Tuple2<String, Iterable<String>>)p, ts));
            }
            case software: {
                return sortedJoinResult.map((Function & Serializable)s -> DedupRecordFactory.softwareMerger((Tuple2<String, Iterable<String>>)s, ts));
            }
            case datasource: {
                return sortedJoinResult.map((Function & Serializable)d -> DedupRecordFactory.datasourceMerger((Tuple2<String, Iterable<String>>)d, ts));
            }
            case organization: {
                return sortedJoinResult.map((Function & Serializable)o -> DedupRecordFactory.organizationMerger((Tuple2<String, Iterable<String>>)o, ts));
            }
            case otherresearchproduct: {
                return sortedJoinResult.map((Function & Serializable)o -> DedupRecordFactory.otherresearchproductMerger((Tuple2<String, Iterable<String>>)o, ts));
            }
        }
        return null;
    }

    private static Publication publicationMerger(Tuple2<String, Iterable<String>> e, long ts) {
        Publication p = new Publication();
        p.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        ArrayList dateofacceptance = Lists.newArrayList();
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(pub -> {
                try {
                    Publication publication = (Publication)mapper.readValue(pub, Publication.class);
                    p.mergeFrom((OafEntity)publication);
                    p.setAuthor(DedupUtility.mergeAuthor(p.getAuthor(), publication.getAuthor()));
                    if (publication.getDateofacceptance() != null) {
                        dateofacceptance.add(publication.getDateofacceptance().getValue());
                    }
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        p.setDateofacceptance(DatePicker.pick(dateofacceptance));
        if (p.getDataInfo() == null) {
            p.setDataInfo(new DataInfo());
        }
        p.getDataInfo().setTrust("0.9");
        p.setLastupdatetimestamp(Long.valueOf(ts));
        return p;
    }

    private static Dataset datasetMerger(Tuple2<String, Iterable<String>> e, long ts) {
        Dataset d = new Dataset();
        d.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        ArrayList dateofacceptance = Lists.newArrayList();
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(dat -> {
                try {
                    Dataset dataset = (Dataset)mapper.readValue(dat, Dataset.class);
                    d.mergeFrom((OafEntity)dataset);
                    d.setAuthor(DedupUtility.mergeAuthor(d.getAuthor(), dataset.getAuthor()));
                    if (dataset.getDateofacceptance() != null) {
                        dateofacceptance.add(dataset.getDateofacceptance().getValue());
                    }
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        d.setDateofacceptance(DatePicker.pick(dateofacceptance));
        if (d.getDataInfo() == null) {
            d.setDataInfo(new DataInfo());
        }
        d.getDataInfo().setTrust("0.9");
        d.setLastupdatetimestamp(Long.valueOf(ts));
        return d;
    }

    private static Project projectMerger(Tuple2<String, Iterable<String>> e, long ts) {
        Project p = new Project();
        p.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(proj -> {
                try {
                    Project project = (Project)mapper.readValue(proj, Project.class);
                    p.mergeFrom((OafEntity)project);
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        if (p.getDataInfo() == null) {
            p.setDataInfo(new DataInfo());
        }
        p.getDataInfo().setTrust("0.9");
        p.setLastupdatetimestamp(Long.valueOf(ts));
        return p;
    }

    private static Software softwareMerger(Tuple2<String, Iterable<String>> e, long ts) {
        Software s = new Software();
        s.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        ArrayList dateofacceptance = Lists.newArrayList();
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(soft -> {
                try {
                    Software software = (Software)mapper.readValue(soft, Software.class);
                    s.mergeFrom((OafEntity)software);
                    s.setAuthor(DedupUtility.mergeAuthor(s.getAuthor(), software.getAuthor()));
                    if (software.getDateofacceptance() != null) {
                        dateofacceptance.add(software.getDateofacceptance().getValue());
                    }
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        s.setDateofacceptance(DatePicker.pick(dateofacceptance));
        if (s.getDataInfo() == null) {
            s.setDataInfo(new DataInfo());
        }
        s.getDataInfo().setTrust("0.9");
        s.setLastupdatetimestamp(Long.valueOf(ts));
        return s;
    }

    private static Datasource datasourceMerger(Tuple2<String, Iterable<String>> e, long ts) {
        Datasource d = new Datasource();
        d.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(dat -> {
                try {
                    Datasource datasource = (Datasource)mapper.readValue(dat, Datasource.class);
                    d.mergeFrom((OafEntity)datasource);
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        if (d.getDataInfo() == null) {
            d.setDataInfo(new DataInfo());
        }
        d.getDataInfo().setTrust("0.9");
        d.setLastupdatetimestamp(Long.valueOf(ts));
        return d;
    }

    private static Organization organizationMerger(Tuple2<String, Iterable<String>> e, long ts) {
        Organization o = new Organization();
        o.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        StringBuilder trust = new StringBuilder("0.0");
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(pub -> {
                try {
                    Organization organization = (Organization)mapper.readValue(pub, Organization.class);
                    String currentTrust = organization.getDataInfo().getTrust();
                    if (!"1.0".equals(currentTrust)) {
                        trust.setLength(0);
                        trust.append(currentTrust);
                    }
                    o.mergeFrom((OafEntity)organization);
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        if (o.getDataInfo() == null) {
            o.setDataInfo(new DataInfo());
        }
        if (o.getDataInfo() == null) {
            o.setDataInfo(new DataInfo());
        }
        o.getDataInfo().setTrust("0.9");
        o.setLastupdatetimestamp(Long.valueOf(ts));
        return o;
    }

    private static OtherResearchProduct otherresearchproductMerger(Tuple2<String, Iterable<String>> e, long ts) {
        OtherResearchProduct o = new OtherResearchProduct();
        o.setId((String)e._1());
        ObjectMapper mapper = new ObjectMapper();
        ArrayList dateofacceptance = Lists.newArrayList();
        if (e._2() != null) {
            ((Iterable)e._2()).forEach(orp -> {
                try {
                    OtherResearchProduct otherResearchProduct = (OtherResearchProduct)mapper.readValue(orp, OtherResearchProduct.class);
                    o.mergeFrom((OafEntity)otherResearchProduct);
                    o.setAuthor(DedupUtility.mergeAuthor(o.getAuthor(), otherResearchProduct.getAuthor()));
                    if (otherResearchProduct.getDateofacceptance() != null) {
                        dateofacceptance.add(otherResearchProduct.getDateofacceptance().getValue());
                    }
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        if (o.getDataInfo() == null) {
            o.setDataInfo(new DataInfo());
        }
        o.setDateofacceptance(DatePicker.pick(dateofacceptance));
        o.getDataInfo().setTrust("0.9");
        o.setLastupdatetimestamp(Long.valueOf(ts));
        return o;
    }
}

