/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.DedupRecordFactory;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.OafEntityType;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;

public class SparkCreateDedupRecord {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateDedupRecord.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createDedupRecord_parameters.json")));
        parser.parseArgument(args);
        new SparkCreateDedupRecord().run(parser);
    }

    private void run(ArgumentApplicationParser parser) throws ISLookUpException, DocumentException {
        String graphBasePath = parser.get("graphBasePath");
        String isLookUpUrl = parser.get("isLookUpUrl");
        String actionSetId = parser.get("actionSetId");
        String workingPath = parser.get("workingPath");
        try (SparkSession spark = SparkCreateDedupRecord.getSparkSession(parser);){
            JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
            for (DedupConfig dedupConf : DedupUtility.getConfigurations(isLookUpUrl, actionSetId)) {
                String subEntity = dedupConf.getWf().getSubEntityValue();
                String mergeRelPath = DedupUtility.createMergeRelPath(workingPath, actionSetId, subEntity);
                String entityPath = DedupUtility.createEntityPath(graphBasePath, subEntity);
                OafEntityType entityType = OafEntityType.valueOf(subEntity);
                JavaRDD<OafEntity> dedupRecord = DedupRecordFactory.createDedupRecord(sc, spark, mergeRelPath, entityPath, entityType, dedupConf);
                dedupRecord.map((Function & Serializable)r -> {
                    ObjectMapper mapper = new ObjectMapper();
                    return mapper.writeValueAsString(r);
                }).saveAsTextFile(DedupUtility.createDedupRecordPath(workingPath, actionSetId, subEntity));
            }
        }
    }

    private static SparkSession getSparkSession(ArgumentApplicationParser parser) {
        SparkConf conf = new SparkConf();
        return SparkSession.builder().appName(SparkCreateDedupRecord.class.getSimpleName()).master(parser.get("master")).config(conf).enableHiveSupport().getOrCreate();
    }
}

