/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class SparkPropagateRelation {
    static final String SOURCEJSONPATH = "$.source";
    static final String TARGETJSONPATH = "$.target";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkPropagateRelation.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/propagateRelation_parameters.json")));
        parser.parseArgument(args);
        new SparkPropagateRelation().run(parser);
    }

    public void run(ArgumentApplicationParser parser) {
        String graphBasePath = parser.get("graphBasePath");
        String workingPath = parser.get("workingPath");
        String dedupGraphPath = parser.get("dedupGraphPath");
        try (SparkSession spark = SparkPropagateRelation.getSparkSession(parser);){
            JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
            Dataset mergeRels = spark.read().load(DedupUtility.createMergeRelPath(workingPath, "*", "*")).as(Encoders.bean(Relation.class));
            JavaPairRDD mergedIds = mergeRels.where("relClass == 'merges'").select(new Column[]{mergeRels.col("source"), mergeRels.col("target")}).distinct().toJavaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getString(1), (Object)r.getString(0)));
            JavaRDD relations = sc.textFile(DedupUtility.createEntityPath(graphBasePath, "relation"));
            JavaRDD newRels = relations.mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)SOURCEJSONPATH, (String)s), s)).leftOuterJoin(mergedIds).map((Function & Serializable)v1 -> {
                if (((Optional)((Tuple2)v1._2())._2()).isPresent()) {
                    return SparkPropagateRelation.replaceField((String)((Tuple2)v1._2())._1(), (String)((Optional)((Tuple2)v1._2())._2()).get(), FieldType.SOURCE);
                }
                return (String)((Tuple2)v1._2())._1();
            }).mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)TARGETJSONPATH, (String)s), s)).leftOuterJoin(mergedIds).map((Function & Serializable)v1 -> {
                if (((Optional)((Tuple2)v1._2())._2()).isPresent()) {
                    return SparkPropagateRelation.replaceField((String)((Tuple2)v1._2())._1(), (String)((Optional)((Tuple2)v1._2())._2()).get(), FieldType.TARGET);
                }
                return (String)((Tuple2)v1._2())._1();
            }).filter(SparkPropagateRelation::containsDedup).repartition(500);
            relations = relations.mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)SOURCEJSONPATH, (String)s), s)).leftOuterJoin(mergedIds).map((Function & Serializable)v1 -> {
                if (((Optional)((Tuple2)v1._2())._2()).isPresent()) {
                    return SparkPropagateRelation.updateDeletedByInference((String)((Tuple2)v1._2())._1(), Relation.class);
                }
                return (String)((Tuple2)v1._2())._1();
            }).mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)TARGETJSONPATH, (String)s), s)).leftOuterJoin(mergedIds).map((Function & Serializable)v1 -> {
                if (((Optional)((Tuple2)v1._2())._2()).isPresent()) {
                    return SparkPropagateRelation.updateDeletedByInference((String)((Tuple2)v1._2())._1(), Relation.class);
                }
                return (String)((Tuple2)v1._2())._1();
            }).repartition(500);
            newRels.union(relations).repartition(1000).saveAsTextFile(DedupUtility.createEntityPath(dedupGraphPath, "relation"), GzipCodec.class);
        }
    }

    private static boolean containsDedup(String json) {
        String source = MapDocumentUtil.getJPathString((String)SOURCEJSONPATH, (String)json);
        String target = MapDocumentUtil.getJPathString((String)TARGETJSONPATH, (String)json);
        return source.toLowerCase().contains("dedup") || target.toLowerCase().contains("dedup");
    }

    private static String replaceField(String json, String id, FieldType type) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Relation relation = (Relation)mapper.readValue(json, Relation.class);
            if (relation.getDataInfo() == null) {
                relation.setDataInfo(new DataInfo());
            }
            relation.getDataInfo().setDeletedbyinference(Boolean.valueOf(false));
            switch (type) {
                case SOURCE: {
                    relation.setSource(id);
                    return mapper.writeValueAsString((Object)relation);
                }
                case TARGET: {
                    relation.setTarget(id);
                    return mapper.writeValueAsString((Object)relation);
                }
            }
            throw new IllegalArgumentException("");
        }
        catch (IOException e) {
            throw new RuntimeException("unable to deserialize json relation: " + json, e);
        }
    }

    private static SparkSession getSparkSession(ArgumentApplicationParser parser) {
        SparkConf conf = new SparkConf();
        return SparkSession.builder().appName(SparkPropagateRelation.class.getSimpleName()).master(parser.get("master")).config(conf).enableHiveSupport().getOrCreate();
    }

    private static <T extends Oaf> String updateDeletedByInference(String json, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Oaf entity = (Oaf)mapper.readValue(json, clazz);
            if (entity.getDataInfo() == null) {
                entity.setDataInfo(new DataInfo());
            }
            entity.getDataInfo().setDeletedbyinference(Boolean.valueOf(true));
            return mapper.writeValueAsString((Object)entity);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert json", e);
        }
    }

    static enum FieldType {
        SOURCE,
        TARGET;

    }
}

