/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.OafEntityType;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class SparkUpdateEntity
implements Serializable {
    final String IDJSONPATH = "$.id";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkUpdateEntity.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/updateEntity_parameters.json")));
        parser.parseArgument(args);
        new SparkUpdateEntity().run(parser);
    }

    public boolean mergeRelExists(String basePath, String entity) throws IOException {
        FileStatus[] fileStatuses;
        boolean result = false;
        FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
        for (FileStatus fs : fileStatuses = fileSystem.listStatus(new Path(basePath))) {
            if (!fs.isDirectory() || !fileSystem.exists(new Path(DedupUtility.createMergeRelPath(basePath, fs.getPath().getName(), entity)))) continue;
            result = true;
        }
        return result;
    }

    public void run(ArgumentApplicationParser parser) throws IOException {
        String graphBasePath = parser.get("graphBasePath");
        String workingPath = parser.get("workingPath");
        String dedupGraphPath = parser.get("dedupGraphPath");
        try (SparkSession spark = SparkUpdateEntity.getSparkSession(parser);){
            JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
            for (OafEntityType entity : OafEntityType.values()) {
                JavaRDD sourceEntity = sc.textFile(DedupUtility.createEntityPath(graphBasePath, entity.toString()));
                if (this.mergeRelExists(workingPath, entity.toString())) {
                    org.apache.spark.sql.Dataset rel = spark.read().load(DedupUtility.createMergeRelPath(workingPath, "*", entity.toString())).as(Encoders.bean(Relation.class));
                    JavaPairRDD mergedIds = rel.where("relClass == 'merges'").select(new Column[]{rel.col("target")}).distinct().toJavaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getString(0), (Object)"d"));
                    JavaRDD dedupEntity = sc.textFile(DedupUtility.createDedupRecordPath(workingPath, "*", entity.toString()));
                    JavaPairRDD entitiesWithId = sourceEntity.mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)"$.id", (String)s), s));
                    JavaRDD map = entitiesWithId.leftOuterJoin(mergedIds).map((Function & Serializable)k -> ((Optional)((Tuple2)k._2())._2()).isPresent() ? SparkUpdateEntity.updateDeletedByInference((String)((Tuple2)k._2())._1(), this.getOafClass(entity)) : (String)((Tuple2)k._2())._1());
                    sourceEntity = map.union(dedupEntity);
                }
                sourceEntity.saveAsTextFile(dedupGraphPath + "/" + (Object)((Object)entity), GzipCodec.class);
            }
        }
    }

    public Class<? extends Oaf> getOafClass(OafEntityType className) {
        switch (className.toString()) {
            case "publication": {
                return Publication.class;
            }
            case "dataset": {
                return Dataset.class;
            }
            case "datasource": {
                return Datasource.class;
            }
            case "software": {
                return Software.class;
            }
            case "organization": {
                return Organization.class;
            }
            case "otherresearchproduct": {
                return OtherResearchProduct.class;
            }
            case "project": {
                return Project.class;
            }
        }
        throw new IllegalArgumentException("Illegal type " + (Object)((Object)className));
    }

    private static <T extends Oaf> String updateDeletedByInference(String json, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Oaf entity = (Oaf)mapper.readValue(json, clazz);
            if (entity.getDataInfo() == null) {
                entity.setDataInfo(new DataInfo());
            }
            entity.getDataInfo().setDeletedbyinference(Boolean.valueOf(true));
            return mapper.writeValueAsString((Object)entity);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert json", e);
        }
    }

    private static SparkSession getSparkSession(ArgumentApplicationParser parser) {
        SparkConf conf = new SparkConf();
        return SparkSession.builder().appName(SparkUpdateEntity.class.getSimpleName()).master(parser.get("master")).config(conf).enableHiveSupport().getOrCreate();
    }
}

