/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.oa.dedup.AuthorMerger;
import eu.dnetlib.dhp.oa.dedup.DedupRecordFactory;
import eu.dnetlib.dhp.oa.dedup.SparkDedupTest;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

public class EntityMergerTest
implements Serializable {
    List<Tuple2<String, Publication>> publications;
    List<Tuple2<String, Publication>> publications2;
    String testEntityBasePath;
    DataInfo dataInfo;
    String dedupId = "dedup_id";
    Publication pub_top;

    @BeforeEach
    public void setUp() throws Exception {
        this.testEntityBasePath = Paths.get(SparkDedupTest.class.getResource("/eu/dnetlib/dhp/dedup/json").toURI()).toFile().getAbsolutePath();
        this.publications = this.readSample(this.testEntityBasePath + "/publication_merge.json", Publication.class);
        this.publications2 = this.readSample(this.testEntityBasePath + "/publication_merge2.json", Publication.class);
        this.pub_top = this.getTopPub(this.publications);
        this.dataInfo = this.setDI();
    }

    @Test
    public void publicationMergerTest() throws InstantiationException, IllegalAccessException {
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)this.dedupId, this.publications.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((Object)this.dedupId, (Object)pub_merged.getId());
        Assertions.assertEquals((Object)pub_merged.getJournal(), (Object)this.pub_top.getJournal());
        Assertions.assertEquals((Object)pub_merged.getBestaccessright(), (Object)this.pub_top.getBestaccessright());
        Assertions.assertEquals((Object)pub_merged.getResulttype(), (Object)this.pub_top.getResulttype());
        Assertions.assertEquals((Object)pub_merged.getLanguage(), (Object)pub_merged.getLanguage());
        Assertions.assertEquals((Object)pub_merged.getPublisher(), (Object)this.pub_top.getPublisher());
        Assertions.assertEquals((Object)pub_merged.getEmbargoenddate(), (Object)this.pub_top.getEmbargoenddate());
        Assertions.assertEquals((Object)pub_merged.getResourcetype().getClassid(), (Object)"0004");
        Assertions.assertEquals((Object)pub_merged.getDateoftransformation(), (Object)this.pub_top.getDateoftransformation());
        Assertions.assertEquals((Object)pub_merged.getOaiprovenance(), (Object)this.pub_top.getOaiprovenance());
        Assertions.assertEquals((Object)pub_merged.getDateofcollection(), (Object)this.pub_top.getDateofcollection());
        Assertions.assertEquals((int)pub_merged.getInstance().size(), (int)3);
        Assertions.assertEquals((int)pub_merged.getCountry().size(), (int)2);
        Assertions.assertEquals((int)pub_merged.getSubject().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getTitle().size(), (int)2);
        Assertions.assertEquals((int)pub_merged.getRelevantdate().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getDescription().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getSource().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getFulltext().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getFormat().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getContributor().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getCoverage().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getContext().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getExternalReference().size(), (int)0);
        Assertions.assertEquals((int)pub_merged.getOriginalId().size(), (int)3);
        Assertions.assertEquals((int)pub_merged.getCollectedfrom().size(), (int)3);
        Assertions.assertEquals((int)pub_merged.getPid().size(), (int)1);
        Assertions.assertEquals((int)pub_merged.getExtraInfo().size(), (int)0);
        Assertions.assertEquals((Object)pub_merged.getDataInfo(), (Object)this.dataInfo);
        Assertions.assertEquals((Object)pub_merged.getDateofacceptance().getValue(), (Object)"2018-09-30");
        Assertions.assertEquals((int)pub_merged.getAuthor().size(), (int)9);
        Assertions.assertEquals((int)AuthorMerger.countAuthorsPids((List)pub_merged.getAuthor()), (int)4);
        int count = 0;
        for (StructuredProperty title : pub_merged.getTitle()) {
            if (!title.getQualifier().getClassid().equals("main title")) continue;
            ++count;
        }
        Assertions.assertEquals((int)count, (int)1);
    }

    @Test
    public void publicationMergerTest2() throws InstantiationException, IllegalAccessException {
        Publication pub_merged = (Publication)DedupRecordFactory.entityMerger((String)this.dedupId, this.publications2.iterator(), (long)0L, (DataInfo)this.dataInfo, Publication.class);
        Assertions.assertEquals((int)pub_merged.getAuthor().size(), (int)27);
    }

    public DataInfo setDI() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.setTrust("0.9");
        dataInfo.setDeletedbyinference(Boolean.valueOf(false));
        dataInfo.setInferenceprovenance("testing");
        dataInfo.setInferred(Boolean.valueOf(true));
        return dataInfo;
    }

    public Publication getTopPub(List<Tuple2<String, Publication>> publications) {
        Double maxTrust = 0.0;
        Publication maxPub = new Publication();
        for (Tuple2<String, Publication> publication : publications) {
            Double pubTrust = Double.parseDouble(((Publication)publication._2()).getDataInfo().getTrust());
            if (!(pubTrust > maxTrust)) continue;
            maxTrust = pubTrust;
            maxPub = (Publication)publication._2();
        }
        return maxPub;
    }

    public <T> List<Tuple2<String, T>> readSample(String path, Class<T> clazz) {
        ArrayList<Tuple2<String, T>> res = new ArrayList<Tuple2<String, T>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String line = reader.readLine();
            while (line != null) {
                res.add(new Tuple2((Object)MapDocumentUtil.getJPathString((String)"$.id", (String)line), new ObjectMapper().readValue(line, clazz)));
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }
}

